/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"
#include "ald_gpio.h"
#include "ald_cmu.h"
#include "ald_dma.h"
#include "ald_iap.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint8_t src_buf[32];
uint8_t dst_buf[32];

/**
  * @brief  DMA send complete.
  * @param  arg: Pointer.
  * @retval None.
  */
void dma_complete(void *arg)
{
	return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer.
  * @retval None.
  */
void dma_error(void *arg)
{
	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();

	/* Initialize dst_buf */
	memset(src_buf, 0x55, 32);
	memset(dst_buf, 0x0, 32);

	ald_iap_erase_page(0xA000, 0);
	ald_iap_program_words(0xA000, src_buf, 32, 0);

	/* Carry data using dma */
	ald_dma_config_auto_easy(DMA0, (void *)0xA000, dst_buf, 32, 0, dma_complete);

	while (1) 
	{
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
