/**
  *********************************************************************************
  *
  * @file    timer.c
  * @brief   timer file for TK DEMO
  *
  * @version V1.0
  * @date    06 Sep 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          06 Sep 2023     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#include <string.h>
#include "ald_cmu.h"
#include "ald_timer.h"
#include "tk_timer.h"
#include "tk_lib.h"

/**
  * @brief  BS16T0 IRQ Handler
  * @retval None
  */
void BS16T0_Handler(void)
{
    BS16T0->ICR = 0x1U;
    timer_10ms = 1;

    return;
}

/**
  * @brief  Initializate BS16T0.
  * @retval None
  */
void bs16t0_init(void)
{
    timer_clock_config_t tim_clock;
    timer_handle_t h_tim_bs16t0;

    timer_10ms = 0x0;
    memset(&h_tim_bs16t0, 0x0, sizeof(h_tim_bs16t0));
    memset(&tim_clock, 0x0, sizeof(tim_clock));
    ald_cmu_perh_clock_config(CMU_PERH_BS16T0, ENABLE);

    /* Initialize BS16T0 */
    h_tim_bs16t0.perh = BS16T0;
    h_tim_bs16t0.init.prescaler    = 47;
    h_tim_bs16t0.init.mode         = TIMER_CNT_MODE_UP;
    h_tim_bs16t0.init.period       = 10000 - 1; /* 10ms */
    h_tim_bs16t0.init.clk_div      = TIMER_CLOCK_DIV1;
    h_tim_bs16t0.init.re_cnt       = 0;
    h_tim_bs16t0.period_elapse_cbk = NULL;
    ald_timer_base_init(&h_tim_bs16t0);

    ald_mcu_irq_config(BS16T0_IRQn, 2, ENABLE);
    ald_timer_interrupt_config(&h_tim_bs16t0, TIMER_IT_UPDATE, ENABLE);
    ald_timer_base_start(&h_tim_bs16t0);

    return;
}
