/**
  *********************************************************************************
  *
  * @file    tk_low_power.h
  * @brief   Header file for TK DEMO
  *
  * @version V1.0
  * @date    06 Sep 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          06 Sep 2023     AE Team         The first version
    *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#ifndef   __TK_LOW_POWER_H__
#define   __TK_LOW_POWER_H__

#include "stdint.h"
#include "ald_lptim.h"
#include "tk_config.h"

#if TK_LOWPOWER_MODE == ON

#define  TK_LP_IDLE_TIME                1000    /* 10s No key press time in normal mode to switch lowpower mode*/
#define  TK_LP_DEBOUNCE_PRESS           2       /* The number of consecutive press in low power mode */
#define  TK_LP_FILTER_CNT               1       /* Count of the filtering, time = TK_LP_FILTER_CNT * LPTIME */

/* Lowpower channael */
#define  TK_NUM_LP              TK_NUM
#define  TK_CHANNEL_SEL_LP      TK_CHANNEL_SEL

#define  TK_CHANNEL_0_LP        TK_CHANNEL_0
#define  TK_CHANNEL_1_LP        TK_CHANNEL_1
#define  TK_CHANNEL_2_LP        TK_CHANNEL_2
#define  TK_CHANNEL_3_LP        TK_CHANNEL_3
#define  TK_CHANNEL_4_LP        TK_CHANNEL_4
#define  TK_CHANNEL_5_LP        TK_CHANNEL_5
#define  TK_CHANNEL_6_LP        TK_CHANNEL_6
#define  TK_CHANNEL_7_LP        TK_CHANNEL_7
#define  TK_CHANNEL_8_LP        TK_CHANNEL_8
#define  TK_CHANNEL_9_LP        TK_CHANNEL_9
#define  TK_CHANNEL_10_LP        TK_CHANNEL_10
#define  TK_CHANNEL_11_LP        TK_CHANNEL_11
#define  TK_CHANNEL_12_LP        TK_CHANNEL_12
#define  TK_CHANNEL_13_LP        TK_CHANNEL_13
#define  TK_CHANNEL_14_LP        TK_CHANNEL_14
#define  TK_CHANNEL_15_LP        TK_CHANNEL_15
#define  TK_CHANNEL_16_LP        TK_CHANNEL_16
#define  TK_CHANNEL_17_LP        TK_CHANNEL_17
#define  TK_CHANNEL_18_LP        TK_CHANNEL_18
#define  TK_CHANNEL_19_LP        TK_CHANNEL_19
#define  TK_CHANNEL_20_LP        TK_CHANNEL_20
#define  TK_CHANNEL_21_LP        TK_CHANNEL_21
#define  TK_CHANNEL_22_LP        TK_CHANNEL_22
#define  TK_CHANNEL_23_LP        TK_CHANNEL_23
#define  TK_CHANNEL_24_LP        TK_CHANNEL_24
#define  TK_CHANNEL_25_LP        TK_CHANNEL_25
#define  TK_CHANNEL_26_LP        TK_CHANNEL_26
#define  TK_CHANNEL_27_LP        TK_CHANNEL_27
#define  TK_CHANNEL_28_LP        TK_CHANNEL_28
#define  TK_CHANNEL_29_LP        TK_CHANNEL_29
#define  TK_CHANNEL_30_LP        TK_CHANNEL_30

#define  TK_THD_CHANNEL_0_LP    (TK_THD_CHANNEL_0 + (TK_THD_CHANNEL_0 >> 2))
#define  TK_THD_CHANNEL_1_LP    (TK_THD_CHANNEL_1 + (TK_THD_CHANNEL_1 >> 2))
#define  TK_THD_CHANNEL_2_LP    (TK_THD_CHANNEL_2 + (TK_THD_CHANNEL_2 >> 2))
#define  TK_THD_CHANNEL_3_LP    (TK_THD_CHANNEL_3 + (TK_THD_CHANNEL_3 >> 2))
#define  TK_THD_CHANNEL_4_LP    (TK_THD_CHANNEL_4 + (TK_THD_CHANNEL_4 >> 2))
#define  TK_THD_CHANNEL_5_LP    (TK_THD_CHANNEL_5 + (TK_THD_CHANNEL_5 >> 2))
#define  TK_THD_CHANNEL_6_LP    (TK_THD_CHANNEL_6 + (TK_THD_CHANNEL_6 >> 2))
#define  TK_THD_CHANNEL_7_LP    (TK_THD_CHANNEL_7 + (TK_THD_CHANNEL_7 >> 2))
#define  TK_THD_CHANNEL_8_LP    (TK_THD_CHANNEL_8 + (TK_THD_CHANNEL_8 >> 2))
#define  TK_THD_CHANNEL_9_LP    (TK_THD_CHANNEL_9 + (TK_THD_CHANNEL_9 >> 2))
#define  TK_THD_CHANNEL_10_LP    (TK_THD_CHANNEL_10 + (TK_THD_CHANNEL_10 >> 2))
#define  TK_THD_CHANNEL_11_LP    (TK_THD_CHANNEL_11 + (TK_THD_CHANNEL_11 >> 2))
#define  TK_THD_CHANNEL_12_LP    (TK_THD_CHANNEL_12 + (TK_THD_CHANNEL_12 >> 2))
#define  TK_THD_CHANNEL_13_LP    (TK_THD_CHANNEL_13 + (TK_THD_CHANNEL_13 >> 2))
#define  TK_THD_CHANNEL_14_LP    (TK_THD_CHANNEL_14 + (TK_THD_CHANNEL_14 >> 2))
#define  TK_THD_CHANNEL_15_LP    (TK_THD_CHANNEL_15 + (TK_THD_CHANNEL_15 >> 2))
#define  TK_THD_CHANNEL_16_LP    (TK_THD_CHANNEL_16 + (TK_THD_CHANNEL_16 >> 2))
#define  TK_THD_CHANNEL_17_LP    (TK_THD_CHANNEL_17 + (TK_THD_CHANNEL_17 >> 2))
#define  TK_THD_CHANNEL_18_LP    (TK_THD_CHANNEL_18 + (TK_THD_CHANNEL_18 >> 2))
#define  TK_THD_CHANNEL_19_LP    (TK_THD_CHANNEL_19 + (TK_THD_CHANNEL_19 >> 2))
#define  TK_THD_CHANNEL_20_LP    (TK_THD_CHANNEL_20 + (TK_THD_CHANNEL_20 >> 2))
#define  TK_THD_CHANNEL_21_LP    (TK_THD_CHANNEL_21 + (TK_THD_CHANNEL_21 >> 2))
#define  TK_THD_CHANNEL_22_LP    (TK_THD_CHANNEL_22 + (TK_THD_CHANNEL_22 >> 2))
#define  TK_THD_CHANNEL_23_LP    (TK_THD_CHANNEL_23 + (TK_THD_CHANNEL_23 >> 2))
#define  TK_THD_CHANNEL_24_LP    (TK_THD_CHANNEL_24 + (TK_THD_CHANNEL_24 >> 2))
#define  TK_THD_CHANNEL_25_LP    (TK_THD_CHANNEL_25 + (TK_THD_CHANNEL_25 >> 2))
#define  TK_THD_CHANNEL_26_LP    (TK_THD_CHANNEL_26 + (TK_THD_CHANNEL_26 >> 2))
#define  TK_THD_CHANNEL_27_LP    (TK_THD_CHANNEL_27 + (TK_THD_CHANNEL_27 >> 2))
#define  TK_THD_CHANNEL_28_LP    (TK_THD_CHANNEL_28 + (TK_THD_CHANNEL_28 >> 2))
#define  TK_THD_CHANNEL_29_LP    (TK_THD_CHANNEL_29 + (TK_THD_CHANNEL_29 >> 2))
#define  TK_THD_CHANNEL_30_LP    (TK_THD_CHANNEL_30 + (TK_THD_CHANNEL_30 >> 2))

typedef struct tk_lp_arr_s
{
    uint16_t org;
    uint16_t avg;
    uint16_t max;
    uint16_t min;
    uint8_t cnt;
    uint8_t flt;
    uint16_t _sum;
} tk_lp_arr_t;

extern uint8_t __sleep_flag;
extern tk_lp_arr_t lp_arr[TK_NUM_LP];

extern void tk_lp_prep(void);
extern void tk_wakeup_prep(void);
extern void tk_lp_enter(void);
extern void tk_lp_init(void);
extern void tk_lp_handler(void);
extern void __tk_lp_value_get(void);

#endif

#endif
