/**
  *********************************************************************************
  *
  * @file    tk_handle.h
  * @brief   Header file for TK DEMO
  *
  * @version V1.0
  * @date    06 Sep 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          06 Sep 2023     AE Team         The first version
    *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#ifndef   __TK_LIB_H__
#define   __TK_LIB_H__

#include "stdint.h"

#define  TK_DEBOUNCE_PRESS              10      /* The number of consecutive press */
#define  TK_DEBOUNCE_RELEASE            5       /* The number of consecutive release */
#define  TK_SAMPLE_PERSCAN                          4
#define  TK_JITTER_THD_LV0                          (uint32_t)((float)tk_jitter_thd_lv0 * 0.3)
#define  TK_JITTER_THD_LV1                          (uint32_t)((float)tk_jitter_thd_lv0 * 0.7)
#define  TK_JITTER_THD_LV2                          (uint32_t)((float)tk_jitter_thd_lv0 * 1.5)
#define  TK_BASE_UP_TIME                                80     /* Count of baseline update,  [1, 65535]*/
#define  TK_PRESS_TIMEOUT               6000    /* 60s, Force cancel the key status, and update the baseline */
#define  AUTO_JITTER_SOFTWARE                       OFF          /* Switch of the software jitter */
#define  AUTO_JITTER_HARDWARE                       OFF         /* Switch of the hardware jitter */
#define  TK_ENHANCE_FILTER

/* TK register value */
#define  TK_REG_CON0                    0x508519U    /* 2MHz */
#define  TK_REG_CON0_BK                 0x308519U    /* 4MHz */
#define  TK_REG_CON1_VDD                0x6038047FU  /* Charge voltage: VDD */
#define  TK_REG_CON1_REF                0x6038047DU  /* Charge voltage: REF 2.4V */
#define  TK_REG_GAIN                    0x000FFFFFU  /* GAIN */
#define  TK_REG_SFJTR                   0x0U         /* Disable HW SFJTR */

#define  SYS_MODE_NORMAL                                0x0
#define  SYS_MODE_LP                                    0x1

#define  ON                             1
#define  OFF                            0

#define  PA_PORT                                                0x00
#define  PB_PORT                                                0x80
#define  PC_PORT                                                0x20

/* Index of the TK channel */
#define  TK_0            (PA_PORT+0)    /* PA0 */
#define  TK_1            (PA_PORT+1)    /* PA1 */
#define  TK_2            (PA_PORT+2)    /* PA2 */
#define  TK_3            (PA_PORT+3)    /* PA3 */
#define  TK_4            (PA_PORT+4)    /* PA4 */
#define  TK_5            (PA_PORT+5)    /* PA5 */
#define  TK_6            (PA_PORT+6)    /* PA6 */
#define  TK_7            (PA_PORT+7)    /* PA7 */
#define  TK_8            (PB_PORT+8)    /* PB0 */
#define  TK_9            (PB_PORT+9)    /* PB1 */
#define  TK_10           (PB_PORT+10)   /* PB2 */
#define  TK_11           (PB_PORT+11)   /* PB10 */
#define  TK_12           (PB_PORT+12)   /* PB11 */
#define  TK_13           (PB_PORT+13)   /* PB12 */
#define  TK_14           (PB_PORT+14)   /* PB13 */
#define  TK_15           (PB_PORT+15)   /* PB14 */
#define  TK_16           (PB_PORT+16)   /* PB15 */
#define  TK_17           (PA_PORT+17)   /* PA8 */
#define  TK_18           (PA_PORT+18)   /* PA9 */
#define  TK_19           (PA_PORT+19)   /* PA10 */
#define  TK_20           (PA_PORT+20)   /* PA11 */
#define  TK_21           (PA_PORT+21)   /* PA12 */
#define  TK_22           (PA_PORT+22)   /* PA15 */
#define  TK_23           (PB_PORT+23)   /* PB3 */
#define  TK_24           (PB_PORT+24)   /* PB4 */
#define  TK_25           (PB_PORT+25)   /* PB5 */
#define  TK_26           (PB_PORT+26)   /* PB6 */
#define  TK_27           (PB_PORT+27)   /* PB7 */
#define  TK_28           (PB_PORT+28)   /* PB9 */
#define  TK_29           (PC_PORT+29)   /* PC2 */
#define  TK_30           (PC_PORT+30)   /* PC3 */
#define  TK_31           (PC_PORT+31)   /* PC4 */

typedef enum
{
    DEFAULT = 0x0U,
    FIRST_POWER_UP = 0x1U,
    RELOCATION = 0x2U,
} tk_init_state_t;

typedef struct
{
    uint32_t tk_org;       /* Origin data */
    uint16_t tk_filter;    /* Filter data */
    uint16_t tk_avg;       /* Base line data */
    uint16_t tk_to_cnt;    /* For TK press time counter */
    uint8_t tk_press;      /* For press counter */
    uint8_t tk_release;    /* For release counter */
    int16_t tk_dlt;        /* Filter data - arg */
    uint16_t tk_thd_up;    /* Auto threshold */
    uint32_t _arg_sum;
    uint16_t _max;
    uint16_t _min;
#ifdef  TK_ENHANCE_FILTER
    int32_t input[3];
    int32_t output[3];
#else
    uint8_t *input;
    uint8_t *output;
#endif
} tk_arr_t;

extern uint8_t tk_value_get;
extern uint8_t tk_anti_motor, tk_adaptive, tk_enhance_filter;
extern uint8_t __tk_jt0_cnt0, __tk_jt0_cnt1;
extern uint32_t tk_jitter_thd_lv0, tk_jitter_thd_lv1, tk_jitter_thd_lv2;
extern uint16_t tk_press_timeout, tk_base_up_time;
extern uint8_t tk_ch_num, tk_sample_perscan, tk_debounce_press, tk_debounce_release;
extern uint8_t tkscan_cnt, base_up_cnt, lock_avg_cnt, timer_10ms;
extern tk_arr_t tk_arr[];          // = tk_value_filter - tk_value_average Чжֵ xh
extern uint32_t tk_state;          // the key state
extern uint32_t tk_state_bk;
extern uint8_t filter_cnt;
extern const uint8_t ch_table[];
extern const uint16_t thd_table[], thd_table_9_10[];
extern tk_init_state_t tk_init_state;
extern uint16_t lp_idle_cnt;
extern uint8_t __sys_mode;

extern void tk_force_average(unsigned char ch);
extern void bsp_tk_init(void);
extern void bsp_tk_handler(void);
extern void tk_press_to(void);
extern void tk_base_up_lock_cnt(void);
extern void tk_service(void);
extern void tk_reg_config(void);
extern void tk_jitter(void);

#endif
