/**
  *********************************************************************************
  *
  * @file    tk_handle.h
  * @brief   Header file for TK DEMO
  *
  * @version V1.0
  * @date    2 Dec 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
    *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#ifndef   __TK_HANDLE_H__
#define   __TK_HANDLE_H__

#include "stdint.h"
#include <rtthread.h>

typedef struct
{
    uint16_t tk_value_origin;     // Origin      data
    uint16_t tk_value_filter;     // Filter      data
    uint16_t tk_value_average;    // Base line   data
    uint16_t tk_timeout_counter;  // For TK press time counter
    uint8_t tk_press_table;       // For press    counter
    uint8_t tk_release_table;     // For release  counter
    uint16_t tk_D_value;          // Base line   data - Filter data
    uint16_t tk_value_max;        // Origin Max     data
    uint16_t tk_value_min;        // Origin Min     data
} TKValueStru;

extern TKValueStru TK_Value_Arr[];
extern TKValueStru curr_tk_value;

extern uint8_t TK_value_get;                    //Temp value flag after scan complete
extern uint8_t Lock_averageconter;              //lock average flag
extern uint8_t Lock_averageconter2;             //lock average flag
extern uint8_t Tkscan_numth;                    //current processing TK channel
extern uint8_t Tkscan_sampcounter;              //sampling count
extern uint8_t Timer_counter;                   //TK run timeout count
extern uint16_t TK_Base_percounter;             //baseline update count
extern uint16_t Opr_state;                      //state machine of TK
extern uint16_t TK_value;                       //Temp value after scan
extern uint16_t TK_jitter_Value;                //maximum and minimum differences
extern uint32_t TK_state;                       //the key state
extern uint32_t TK_state_single;                //maximum key state
//extern uint32_t  TK_state_bk;                   //for backup
extern const uint8_t Channel_table[];           //Channel table for use as tk channel
//extern const uint8_t Channel_table_LP[];
extern const uint16_t Threshold_table[];        //Threshold table for tk channel
//extern const uint16_t Threshold_table_LP[];

//for TK lib
extern uint8_t TK_chnum;
extern const uint8_t DF_TK_Singlepress;
extern const uint32_t DF_TK_reg_CON0;
extern const uint32_t DF_TK_reg_CON0_bk1;

extern rt_sem_t nw_TK_value;

extern int TK_sample(void);
extern uint16_t DataFilter(uint16_t Origin, uint16_t Befilter);

#endif
