/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    7 Jul 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          7 Jul 2023      AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  CMU IRQ#6 handler
  * @retval None
  */
void CMU_Handler(void)
{
    ald_cmu_irq_handler();
    return;
}

#ifdef ALD_DMA
/**
  * @brief  DMA IRQ#66 handler
  * @retval None
  */
void DMA_Handler(void)
{
    ald_dma_irq_handler();
}
#endif

/**
  * @brief  TKS IRQ handler
  * @retval None
  */
void TKS_Handler(void)
{
    /* enter interrupt */
    rt_interrupt_enter();

    if (TKS->IF)   // Check if scan complete TKGO TKIF TKGO==0
    {
        if (TKS->IF & 0x00000010)
        {
            Timer_counter = 0;             //Clear Measure time for tk module
            TK_value_get = 1;              //Set a flag for TK_value  update

            rt_sem_release(nw_TK_value);
        }
        else
        {
            TK_value_get = 0;
        }

        if (Lock_averageconter > 2)
        {
            if (0x00600000 != (TKS->CON0 & 0x00F00000))
            {
                TKS->CON0 &= ~0x00F00000;
                TKS->CON0 |= 0x00600000; //ı乤ƵΪ3MHz
            }
        }
        else
        {
            if (0x00500000 != (TKS->CON0 & 0x00F00000))
            {
                TKS->CON0 &= ~0x00F00000;
                TKS->CON0 |= 0x00500000; //ı乤ƵΪ2MHz
            }
        }

        TKS->IFC |= 0x0000001F;          // ж

        if (TK_value_get == 0)
        {
            {
                TKS->CON0 |= 0x00000002;                            // ʹܴʹģ飬TKGO = 1ɨ
            }
        }
    }

    /* leave interrupt */
    rt_interrupt_leave();
}

/**
  * @}
  */
/**
  * @}
  */
