/**
  *********************************************************************************
  *
  * @file    display.c
  * @brief   Display Process
  *
  * @version V1.0
  * @date    2 Dec 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#include <string.h>
#include "ald_cmu.h"
#include "ald_gpio.h"
#include "tkm_config.h"
#include "tk_handle.h"
#include "display.h"

uint8_t dispBuf[4];
uint8_t Press_counter;
lcd_handle_t h_lcd;

const uint16_t dispNumTab[] =
{
    NUM_0,       //0
    NUM_1,       //1
    NUM_2,       //2
    NUM_3,       //3
    NUM_4,       //4
    NUM_5,       //5
    NUM_6,       //6
    NUM_7,       //7
    NUM_8,       //8
    NUM_9,       //9
    NUM_A,       //10
    NUM_b,       //11
    NUM_C,       //12
    NUM_d,       //13
    NUM_E,       //14
    NUM_F,       //15
    NUM_All,     //16
    NUM_None,    //17
};

/**
  * @brief  Initializate LED pin.
  * @retval None
  */
void led_pin_init(void)
{
    gpio_init_t x;
    memset(&x, 0x0, sizeof(x));

    ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);

    x.mode = GPIO_MODE_CLOSE;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_FLOATING;
    x.podrv = GPIO_OUT_DRIVE_20;
    x.nodrv = GPIO_OUT_DRIVE_20;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = GPIO_FUNC_0;
    ald_gpio_init(GPIOA, led_com_1 | led_com_2 | led_com_3, &x);
    ald_gpio_init(GPIOB, led_com_4 | led_seg_A | led_seg_B | led_seg_C | led_seg_D | led_seg_E | led_seg_F | led_seg_G | led_seg_H, &x);
}

/**
  * @brief  Initializate LCD/LED.
  * @retval None
  */
void LCD_Init(void)
{
    TK_state_bk = 0;
    Press_counter = 0;

    memset(&h_lcd, 0x0, sizeof(h_lcd));
    /* Initialize pin */
    led_pin_init();

    ald_cmu_perh_clock_config(CMU_PERH_LCD, ENABLE);
    /* Initialize lcd */
    h_lcd.perh = LCD;
    h_lcd.init.lcd_bias   = LCD_BIAS_1_2;
    h_lcd.init.lcd_div    = LCD_DIV_16;
    h_lcd.init.lcd_duty   = LCD_DUTY_1_4;
    h_lcd.init.lcd_prs    = LCD_PRS_1;
    h_lcd.init.lcd_reshd  = LCD_RES_3MOHM;
    h_lcd.init.lcd_resld  = LCD_RES_3MOHM;
    h_lcd.init.lcd_vbufhd = LCD_FUNC_ENABLE;
    h_lcd.init.lcd_vbufld = LCD_FUNC_DISABLE;
    h_lcd.init.lcd_vchps  = LCD_VCHPS_3V2;
    h_lcd.init.lcd_vsel   = LCD_VSEL_VDD;
    h_lcd.init.lcd_wfs    = LCD_WAVE_A;
    h_lcd.init.lcd_vgs    = LCD_VGS_6;
    h_lcd.init.clock      = CMU_LCD_SEL_HRC_1M;
    ald_lcd_init(&h_lcd);

    ald_lcd_write_seg(&h_lcd, reg_seg_A | reg_seg_B | reg_seg_C | reg_seg_D | reg_seg_E | reg_seg_F | reg_seg_G | reg_seg_H);

    /* Enable lcd */
    ald_lcd_cmd(&h_lcd, ENABLE);
    ald_lcd_led_init(&h_lcd, ENABLE);
}
