/**
  *********************************************************************************
  *
  * @file    uart.c
  * @brief   Communicate with PC for debug
  *
  * @version V1.0
  * @date    2 Dec 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#include <string.h>
#include "ald_cmu.h"
#include "ald_rmu.h"
#include "ald_gpio.h"
#include "tkm_config.h"
#include "tk_handle_S&W.h"
#include "tk_low_power.h"
#include "uart.h"

#if TK_UARToutput_function == ON

#if TK_UART_TYPE == TKM_UART
    uart_handle_t h_uart;
#endif
#if TK_UART_TYPE == TKM_USART
    usart_handle_t h_usart0;
#endif
#if TK_UART_TYPE == TKM_LPUART
    lpuart_handle_t h_lpuart;
#endif
uint8_t Cnt_Mask;
uint32_t ChannelMask;
uint8_t g_com;                          //
uint8_t g_length;                       //ݳ
uint8_t g_rp;                           //ָ
uint8_t g_tp;                           //ָ
uint8_t g_checksum;                     //У
uint8_t Tx_timer;
uint8_t Rx_timer;
uint8_t UploadSampByte[(TK_NUM * 2) + 5]; //ֽ
uint8_t UploadRawByte[(TK_NUM * 2) + 5]; //˲ֽ
uint8_t UploadBaseByte[(TK_NUM * 2) + 5]; //ֽ
#if ((TK_NUM*2)+5) < 14
    uint8_t UploadBuf[14];      //ͻ
#else
    uint8_t UploadBuf[(TK_NUM * 2) + 5];    //ͻ
#endif
uint8_t Uart_ready;
uint8_t rst_flag;
#if TK_Lowpowermode == ON
    uint8_t uart_send_flag;
    #if TK_LP_dataprocess_mode  == Merge
        uint16_t TK_md2value_origin;
    #endif
    #if TK_LP_dataprocess_mode == Poll
        uint16_t TK_md2value_origin[TK_NUM];
    #endif

#endif

/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
#if TK_UART_TYPE == TKM_UART
    void uart_pin_init(void)
#endif
#if TK_UART_TYPE == TKM_USART
    void usart_pin_init(void)
#endif
#if TK_UART_TYPE == TKM_LPUART
    void lpuart_pin_init(void)
#endif
{
    gpio_init_t x;
    memset(&x, 0x0, sizeof(x));

    ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
    /* Initialize tx pin */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_6;
    x.nodrv = GPIO_OUT_DRIVE_6;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = UART_FUNC;
    ald_gpio_init(UART_PORT, UART_TX, &x);

    /* Initialize rx pin */
    x.mode = GPIO_MODE_INPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_6;
    x.nodrv = GPIO_OUT_DRIVE_6;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = UART_FUNC;
    ald_gpio_init(UART_PORT, UART_RX, &x);

    return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
#if TK_UART_TYPE == TKM_UART
    void uart_send_complete(uart_handle_t *arg)
#endif
#if TK_UART_TYPE == TKM_USART
    void usart0_send_complete(usart_handle_t *arg)
#endif
#if TK_UART_TYPE == TKM_LPUART
    void lpuart_send_complete(lpuart_handle_t *arg)
#endif
{
    g_tp = 0;           //ָ0
    Tx_timer = 0;       //Clear counter
    Uart_ready = 1;
#if TK_Lowpowermode == ON
    Uart_ready = 0;
    Rx_timer = 1;
#if TK_UART_TYPE == TKM_UART
    ald_uart_recv_by_it(&h_uart, &g_com, 1);
#endif
#if TK_UART_TYPE == TKM_USART
    ald_usart_recv_by_it(&h_usart0, &g_com, 1);
#endif
#if TK_UART_TYPE == TKM_LPUART
    ald_lpuart_recv_by_it(&h_lpuart, &g_com, 1);
#endif

    if (uart_send_flag > 2)
    {
        uart_send_flag = 4;
    }

#endif

    if (rst_flag)
    {
        rst_flag = 0;
        ald_rmu_reset_periperal(RMU_PERH_CPU);
    }

    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
#if TK_UART_TYPE == TKM_UART
    void uart_recv_complete(uart_handle_t *arg)
#endif
#if TK_UART_TYPE == TKM_USART
    void usart0_recv_complete(usart_handle_t *arg)
#endif
#if TK_UART_TYPE == TKM_LPUART
    void lpuart_recv_complete(lpuart_handle_t *arg)
#endif
{
//    uint8_t temp;
    UploadBuf[0] = 0x68;
    UploadBuf[1] = 0x68;
    UploadBuf[2] = g_com;
    g_rp = 0;            //ָ0
    Cnt_Mask = 0;
    g_checksum = 0;      //У0
    Rx_timer = 0;        //ճʱ0

    if (g_tp == 0)       //Not in busy send state
    {
        if (g_com == COMMOND1)
        {
            g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2];    //Уͣۼֵ
#if TK_Lowpowermode == ON

            if (g_wakeup_flag == 0)
            {
                while (Cnt_Mask < (TK_NUM * 2))
                {
                    if (0x00000001 << (Cnt_Mask / 2))
//                  if ((0x00000001 << (Cnt_Mask / 2)) & ChannelMask)
                    {
                        UploadBuf[g_rp + 4] = 0;
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
                        Cnt_Mask++;
                    }
                    else
                    {
                        Cnt_Mask++;
                    }
                }
            }
            else
#endif
            {
                while (Cnt_Mask < (TK_NUM * 2))
                {
                    if (0x00000001 << (Cnt_Mask / 2))
//                  if ((0x00000001 << (Cnt_Mask / 2)) & ChannelMask)
                    {
                        UploadBuf[g_rp + 4] = UploadSampByte[Cnt_Mask];
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
                        Cnt_Mask++;
                    }
                    else
                    {
                        Cnt_Mask++;
                    }
                }
            }

//            g_length = g_rp;
            UploadBuf[3] = g_rp;
            g_checksum += UploadBuf[3];
            UploadBuf[g_rp + 4] = g_checksum;
            /* Send a message */
#if TK_UART_TYPE == TKM_UART
            ald_uart_send_by_it(&h_uart, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_USART
            ald_usart_send_by_it(&h_usart0, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_LPUART
            ald_lpuart_send_by_it(&h_lpuart, UploadBuf, g_rp + 5);
#endif
            g_tp = 1;
        }
        else if (g_com == COMMOND2)
        {
            g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;   //Уͣۼֵ
#if TK_Lowpowermode == ON

            if (g_wakeup_flag == 0)
            {
                while (Cnt_Mask < TK_NUM)
                {
                    if (0x00000001 << (Cnt_Mask / 2))
//                  if ((0x00000001 << (Cnt_Mask / 2)) & ChannelMask)
                    {
#if TK_LP_dataprocess_mode  == Merge
                        UploadBuf[g_rp + 4] = (uint8_t)(TK_md2value_origin >> 8);
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
                        UploadBuf[g_rp + 4] = (uint8_t)(TK_md2value_origin);
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
#endif
#if TK_LP_dataprocess_mode  == Poll
                        UploadBuf[g_rp + 4] = (uint8_t)(TK_md2value_origin[Cnt_Mask] >> 8);
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
                        UploadBuf[g_rp + 4] = (uint8_t)(TK_md2value_origin[Cnt_Mask]);
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
#endif
                    }

                    Cnt_Mask++;
                }
            }
            else
#endif
            {
                while (Cnt_Mask < (TK_NUM * 2))
                {
                    if (0x00000001 << (Cnt_Mask / 2))
//                  if ((0x00000001 << (Cnt_Mask / 2)) & ChannelMask)
                    {
                        UploadBuf[g_rp + 4] = UploadRawByte[Cnt_Mask];
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
                        Cnt_Mask++;
                    }
                    else
                    {
                        Cnt_Mask++;
                    }
                }
            }

//            g_length = g_rp;
            UploadBuf[3] = g_rp;
            g_checksum += UploadBuf[3];
            UploadBuf[g_rp + 4] = g_checksum;
            /* Send a message */
#if TK_UART_TYPE == TKM_UART
            ald_uart_send_by_it(&h_uart, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_USART
            ald_usart_send_by_it(&h_usart0, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_LPUART
            ald_lpuart_send_by_it(&h_lpuart, UploadBuf, g_rp + 5);
#endif
            g_tp = 1;
        }
        else if (g_com == COMMOND3)
        {
            g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;   //Уͣۼֵ
#if TK_Lowpowermode == ON

            if (g_wakeup_flag == 0)
            {
                while (Cnt_Mask < TK_NUM)
                {
                    if (0x00000001 << (Cnt_Mask / 2))
//                  if ((0x00000001 << (Cnt_Mask / 2)) & ChannelMask)
                    {
#if TK_LP_dataprocess_mode  == Merge
                        UploadBuf[g_rp + 4] = (uint8_t)(TK_md2average_backup >> 8);
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
                        UploadBuf[g_rp + 4] = (uint8_t)(TK_md2average_backup);
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
#endif
#if TK_LP_dataprocess_mode  == Poll
                        UploadBuf[g_rp + 4] = (uint8_t)(TK_md2average_backup[Cnt_Mask] >> 8);
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
                        UploadBuf[g_rp + 4] = (uint8_t)(TK_md2average_backup[Cnt_Mask]);
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
#endif
                    }

                    Cnt_Mask++;
                }
            }
            else
#endif
            {
                while (Cnt_Mask < (TK_NUM * 2))
                {
                    if (0x00000001 << (Cnt_Mask / 2))
//                  if ((0x00000001 << (Cnt_Mask / 2)) & ChannelMask)
                    {
                        UploadBuf[g_rp + 4] = UploadBaseByte[Cnt_Mask];
                        g_checksum += UploadBuf[g_rp + 4];  //Уͣۼֵ
                        g_rp++;
                        Cnt_Mask++;
                    }
                    else
                    {
                        Cnt_Mask++;
                    }
                }
            }

//            g_length = g_rp;
            UploadBuf[3] = g_rp;
            g_checksum += UploadBuf[3];
            UploadBuf[g_rp + 4] = g_checksum;
            /* Send a message */
#if TK_UART_TYPE == TKM_UART
            ald_uart_send_by_it(&h_uart, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_USART
            ald_usart_send_by_it(&h_usart0, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_LPUART
            ald_lpuart_send_by_it(&h_lpuart, UploadBuf, g_rp + 5);
#endif
            g_tp = 1;
#if TK_Lowpowermode == ON

            if (uart_send_flag)
            {
                uart_send_flag++;
            }

#endif
        }
        else if (g_com == COMMOND4) //ֵ
        {
//            g_length = 9;
            UploadBuf[3] = 9;

            UploadBuf[4] = (uint8_t)(Opr_state);         //Mode

#if  TK_Singlepress == ON
            UploadBuf[5] = (uint8_t)(TK_state_single >> 16);  //ֵH
            UploadBuf[6] = (uint8_t)(TK_state_single >> 8);     //ֵM
            UploadBuf[7] = (uint8_t)(TK_state_single);      //ֵL
#else
            UploadBuf[5] = (uint8_t)(TK_state >> 16);  //ֵH
            UploadBuf[6] = (uint8_t)(TK_state >> 8); //ֵM
            UploadBuf[7] = (uint8_t)(TK_state);      //ֵL
#endif

#if  TK_Slider_Function == ON
            UploadBuf[8] = (uint8_t)(TK_slider_value >> 8);  //Byte H
            UploadBuf[9] = (uint8_t)(TK_slider_value);       //Byte L
#else
            //UploadBuf[8] = 0;
            //UploadBuf[9] = 0;
            UploadBuf[8] = (uint8_t)(TK_jitter_Value >> 8);  //Byte H
            UploadBuf[9] = (uint8_t)(TK_jitter_Value);       //Byte L
#endif

#if  TK_Wheel_Function == ON
            UploadBuf[10] = (uint8_t)(TK_wheel_value >> 8);  //Byte H
            UploadBuf[11] = (uint8_t)(TK_wheel_value);       //Byte L
#else
            UploadBuf[10] = 0;
            UploadBuf[11] = 0;
#endif

#if  TK_Matrix_Function == ON
            UploadBuf[12] = TK_Matrix_value ;               //Byte
#else
            UploadBuf[12] = 0;                             //Byte
#endif
            g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3] + UploadBuf[4] + UploadBuf[5];   //Уͣۼֵ
            g_checksum += UploadBuf[6] + UploadBuf[7] + UploadBuf[8] + UploadBuf[9] + UploadBuf[10] + UploadBuf[11] + UploadBuf[12]; //Уͣۼֵ
            UploadBuf[13] = g_checksum;
            /* Send a message */
#if TK_UART_TYPE == TKM_UART
            ald_uart_send_by_it(&h_uart, UploadBuf, 14);
#endif
#if TK_UART_TYPE == TKM_USART
            ald_usart_send_by_it(&h_usart0, UploadBuf, 14);
#endif
#if TK_UART_TYPE == TKM_LPUART
            ald_lpuart_send_by_it(&h_lpuart, UploadBuf, 14);
#endif
            g_tp = 1;
        }
        else if (g_com == COMMOND0) //ͨ
        {
//            g_length     = 1;
            UploadBuf[3] = 1;
            g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];     //Уͣۼֵ
            UploadBuf[4] = TK_NUM;
            g_checksum += UploadBuf[4];                                                 //Уͣۼֵ
            g_rp++;
            UploadBuf[g_rp + 4] = g_checksum;
            /* Send a message */
#if TK_UART_TYPE == TKM_UART
            ald_uart_send_by_it(&h_uart, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_USART
            ald_usart_send_by_it(&h_usart0, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_LPUART
            ald_lpuart_send_by_it(&h_lpuart, UploadBuf, g_rp + 5);
#endif
            g_tp = 1;
        }
        else if (g_com == COMMOND6) //ͨ
        {
//          g_length     = 1;
            UploadBuf[3] = 1;
            g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];     //Уͣۼֵ
            UploadBuf[4] = 0x05;
            g_checksum += UploadBuf[4];                                                 //Уͣۼֵ
            g_rp ++;
            UploadBuf[g_rp + 4] = g_checksum;
            /* Send a message */
#if TK_UART_TYPE == TKM_UART
            ald_uart_send_by_it(&h_uart, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_USART
            ald_usart_send_by_it(&h_usart0, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_LPUART
            ald_lpuart_send_by_it(&h_lpuart, UploadBuf, g_rp + 5);
#endif
            g_tp = 1;
        }
        else if (g_com == COMMOND7)
        {
//          g_length     = 1;
            UploadBuf[3] = 1;
            g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];     //Уͣۼֵ
            UploadBuf[4] = 0xAA;
            g_checksum += UploadBuf[4];                                                 //Уͣۼֵ
            g_rp ++;
            UploadBuf[g_rp + 4] = g_checksum;
            /* Send a message */
#if TK_UART_TYPE == TKM_UART
            ald_uart_send_by_it(&h_uart, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_USART
            ald_usart_send_by_it(&h_usart0, UploadBuf, g_rp + 5);
#endif
#if TK_UART_TYPE == TKM_LPUART
            ald_lpuart_send_by_it(&h_lpuart, UploadBuf, g_rp + 5);
#endif
            g_tp = 1;
            rst_flag = 1;
        }

//        else
//        {
//            temp = ((g_com & 0xF0) >> 4) - 6;
//            ChannelMask &= ~(0x0000000F << (temp * 4));
//            ChannelMask |= ((g_com & 0x0F) << (temp * 4));
//            g_length     = 0;
//            UploadBuf[3] = 0;
//            g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];     //Уͣۼֵ
//            g_rp++;
//            UploadBuf[4] = g_checksum;
//            /* Send a message */
//            ald_uart_send_by_it(&h_uart, UploadBuf, 5);
//            g_tp = 1;
//        }
    }
    else
    {
        if (Tx_timer == 0)
        {
            Tx_timer = 1;
        }
    }

    return;
}

/**
  * @brief  Send and receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
#if TK_UART_TYPE == TKM_UART
    void uart_send_recv_complete(uart_handle_t *arg)
#endif
#if TK_UART_TYPE == TKM_USART
    void usart_send_recv_complete(usart_handle_t *arg)
#endif
#if TK_UART_TYPE == TKM_LPUART
    void lpuart_send_recv_complete(lpuart_handle_t *arg)
#endif
{
    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
#if TK_UART_TYPE == TKM_UART
    void uart_error(uart_handle_t *arg)
#endif
#if TK_UART_TYPE == TKM_USART
    void usart0_error(usart_handle_t *arg)
#endif
#if TK_UART_TYPE == TKM_LPUART
    void lpuart_error(lpuart_handle_t *arg)
#endif
{
    return;
}

/**
  * @brief:  Initialize the UART.
  * @param:  None
  * @retval: None
  */
#if TK_UART_TYPE == TKM_UART
    void UART_Init(void)
#endif
#if TK_UART_TYPE == TKM_USART
    void USART_Init(void)
#endif
#if TK_UART_TYPE == TKM_LPUART
    void LPUART_Init(void)
#endif
{
#if TK_UART_TYPE == TKM_UART
    /* clear usart_handle_t structure */
    memset(&h_uart, 0x0, sizeof(h_uart));
    /* Initialize pin */
    uart_pin_init();
    ald_cmu_perh_clock_config(CMU_PERH_UART0, ENABLE);
    /* Initialize uart */
    h_uart.perh               = UART0;
    h_uart.init.baud          = TK_UARToutput_Baudrate;
    h_uart.init.word_length   = UART_WORD_LENGTH_8B;
    h_uart.init.stop_bits     = UART_STOP_BITS_1;
    h_uart.init.parity        = UART_PARITY_NONE;
    h_uart.init.mode          = UART_MODE_UART;
    h_uart.init.fctl          = UART_HW_FLOW_CTL_DISABLE;
    h_uart.tx_cplt_cbk        = uart_send_complete;
    h_uart.rx_cplt_cbk        = uart_recv_complete;
    h_uart.error_cbk          = uart_error;
    ald_uart_init(&h_uart);
    /* Enable uart interrupt */
    ald_mcu_irq_config(UART0_IRQn, 1, ENABLE);
    /* Receive a message */
    ald_uart_recv_by_it(&h_uart, &g_com, 1);
#endif
#if TK_UART_TYPE == TKM_USART
    /* clear usart_handle_t structure */
    memset(&h_usart0, 0x0, sizeof(h_usart0));
    /* Initialize pin */
    usart_pin_init();
    ald_cmu_perh_clock_config(CMU_PERH_USART0, ENABLE);
    /* Initialize uart */
    h_usart0.perh             = USART0;
    h_usart0.init.baud        = TK_UARToutput_Baudrate;
    h_usart0.init.word_length = USART_WORD_LENGTH_8B;
    h_usart0.init.stop_bits   = USART_STOP_BITS_1;
    h_usart0.init.parity      = USART_PARITY_NONE;
    h_usart0.init.mode        = USART_MODE_TX_RX;
    h_usart0.init.fctl        = USART_HW_FLOW_CTL_NONE;
    h_usart0.tx_cplt_cbk      = usart0_send_complete;
    h_usart0.rx_cplt_cbk      = usart0_recv_complete;
    h_usart0.error_cbk        = usart0_error;
    ald_usart_init(&h_usart0);
    /* Enable usart interrupt */
    ald_mcu_irq_config(USART0_IRQn, 1, ENABLE);
    /* Receive a message */
    ald_usart_recv_by_it(&h_usart0, &g_com, 1);
#endif
#if TK_UART_TYPE == TKM_LPUART
    /* clear usart_handle_t structure */
    memset(&h_lpuart, 0x0, sizeof(h_lpuart));
    /* Initialize pin */
    lpuart_pin_init();
    ald_cmu_perh_clock_config(CMU_PERH_LPUART0, ENABLE);
    /* Initialize uart */
    h_lpuart.perh             = LPUART0;
    h_lpuart.init.baud        = TK_UARToutput_Baudrate;
    h_lpuart.init.word_length = LPUART_WORD_LENGTH_8B;
    h_lpuart.init.stop_bits   = LPUART_STOP_BITS_1;
    h_lpuart.init.parity      = LPUART_PARITY_NONE;
    h_lpuart.init.mode        = LPUART_MODE_UART;
    h_lpuart.init.fctl        = LPUART_HW_FLOW_CTL_NONE;
    h_lpuart.tx_cplt_cbk      = lpuart_send_complete;
    h_lpuart.rx_cplt_cbk      = lpuart_recv_complete;
    h_lpuart.error_cbk        = lpuart_error;
    ald_lpuart_init(&h_lpuart);
    /* Enable lpuart interrupt */
    ald_mcu_irq_config(LPUART0_IRQn, 1, ENABLE);
    /* Receive a message */
    ald_lpuart_recv_by_it(&h_lpuart, &g_com, 1);
#endif

    Uart_ready = 0;
    rst_flag = 0;
    Rx_timer = 1;
}

#endif
