/**
  *********************************************************************************
  *
  * @file    timer.c
  * @brief   timer file for TK DEMO
  *
  * @version V1.0
  * @date    2 Dec 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#include <string.h>
#include "ald_cmu.h"
#include "ald_timer.h"
#include "timer.h"
#include "tkm_config.h"
#include "tk_handle_S&W.h"
#include "tk_low_power.h"

uint8_t Timer_10ms;
timer_handle_t h_tim1;

/**
  * @brief  period elapsed call back.
  * @param  arg: Pointer to timer_handle_s structure.
  * @retval None
  */
void ald_timer_periodelapsedcallback(struct timer_handle_s *arg)
{
    Timer_10ms++;

    if (Opr_state & 0x8000) //At scan enable state
    {
        if (TKS->IF) // Check if scan complete TKGO TKIF TKGO==0
        {
            if (TKS->IF & 0x00000010)
            {
                Timer_counter = 0;             //Clear Measure time for tk module
                TK_value_get = 1;              //Set a flag for TK_value  update
            }
            else
            {
                TK_value_get = 0;
            }

#if Auto_Jitter_software == ON

            if (Lock_averageconter > 2)
            {
                if (0x00500000 != (TKS->CON0 & 0x00F00000))
                {
                    TKS->CON0 &= ~0x00F00000;
                    TKS->CON0 |= 0x00500000; //ı乤ƵΪ2MHz
                }
            }
            else
            {
                if (0x00300000 != (TKS->CON0 & 0x00F00000))
                {
                    TKS->CON0 &= ~0x00F00000;
                    TKS->CON0 |= 0x00300000; //ı乤ƵΪ4MHz
                }
            }

#endif
//          TKS_CON0_ram &= 0x00F00000;  // Clear other bits
//          TKS_CON0_ram |= (TKS->CON0 & 0xFF0FFFFF); // Keep other bits
//          TKS->CON0 = TKS_CON0_ram;     //

            TKS->IFC |= 0x0000001F;          // ж

            if (TK_value_get == 0)
            {
#if TK_Lowpowermode == ON

                if (g_wakeup_flag != 2)
#endif
                {
                    TKS->CON0 |= 0x00000002;                            // ʹܴʹģ飬TKGO = 1ɨ
                }
            }
        }
        else if (TK_value_get == 2)
        {
#if TK_Lowpowermode == ON

            if (g_wakeup_flag != 2)
#endif
            {
                TKS->CON0 |= 0x00000002;                            // ʹܴʹģ飬TKGO = 1ɨ
                TK_value_get = 0;
            }
        }
    }
}

/**
  * @brief  Initializate BS16T0.
  * @retval None
  */
void BS16T0_Init(void)
{
    timer_clock_config_t tim_clock;

    memset(&h_tim1, 0x0, sizeof(h_tim1));
    memset(&tim_clock, 0x0, sizeof(tim_clock));

    ald_cmu_perh_clock_config(CMU_PERH_BS16T0, ENABLE);
    /* Initialize BS16T0 */
    h_tim1.perh = BS16T0;
    h_tim1.init.prescaler    = 47;
    h_tim1.init.mode         = TIMER_CNT_MODE_UP;
    h_tim1.init.period       = 125; //125us
    h_tim1.init.clk_div      = TIMER_CLOCK_DIV1;
    h_tim1.init.re_cnt       = 0;
    h_tim1.period_elapse_cbk = ald_timer_periodelapsedcallback;
    ald_timer_base_init(&h_tim1);

    /* Initialize clock source */
    tim_clock.source = TIMER_SRC_INTER;
    ald_timer_config_clock_source(&h_tim1, &tim_clock);

    /* Enable BS16T0 interrupt */
    ald_mcu_irq_config(BS16T0_IRQn, 2, ENABLE);

    /* Enable UPDATE interrupt */
    ald_timer_interrupt_config(&h_tim1, TIMER_IT_UPDATE, ENABLE);

    /* Start input pwm from BS16T0 channel 1 */
    ald_timer_base_start(&h_tim1);
}
