/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0.2
  * @date    29 Dec 2022
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
  *          28 Apr 2022     AE Team         modify the system clock
  *          29 Dec 2022     AE Team         Add serial port options
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
    /* Configure WDT */
#if IWDT_function == ON
    ald_iwdt_init(IWDT_5s, DISABLE);
    ald_iwdt_start();
#endif
    /* Display Set */
#if TK_IOoutput_function == ON
    Led_init();
#endif
    /* Initialize TK*/
    TK_Init();
    /* Initialize BS16T0 */
    BS16T0_Init();
    /* Initialize UART */
#if TK_UARToutput_function == ON
#if TK_UART_TYPE == TKM_UART
    UART_Init();
#endif
#if TK_UART_TYPE == TKM_USART
    USART_Init();
#endif
#if TK_UART_TYPE == TKM_LPUART
    LPUART_Init();
#endif
#endif

    while (1)
    {
#if IWDT_function == ON
        ald_iwdt_feed_dog();
#endif
#if TK_Lowpowermode == ON

        if (g_wakeup_flag == 0)
        {
            TKStandby();                       // sleep mode
        }
        else
#endif
        {
            Tk_service();
            Timer_check();                      //Check if 10ms tick
            Update_TKdata();                    //Update channel data
#if TK_UARToutput_function == ON

            if (Uart_ready)
            {
                Uart_ready = 0;
                Rx_timer = 1;
#if TK_UART_TYPE == TKM_UART
                ald_uart_recv_by_it(&h_uart, &g_com, 1);
#endif
#if TK_UART_TYPE == TKM_USART
                ald_usart_recv_by_it(&h_usart0, &g_com, 1);
#endif
#if TK_UART_TYPE == TKM_LPUART
                ald_lpuart_recv_by_it(&h_lpuart, &g_com, 1);
#endif
            }

#endif
#if TK_Lowpowermode == ON

            if (g_wakeup_flag == 0)
            {
                Customer_prepareforsleepmode_init();
            }

#endif
        }
    }
}

/**
  * @}
  */
/**
  * @}
  */
