/**
  *********************************************************************************
  *
  * @file    display.c
  * @brief   Display Process
  *
  * @version V1.0
  * @date    2 Dec 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */
#include <string.h>
#include "ald_cmu.h"
#include "ald_gpio.h"
#include "tkm_config.h"
#include "tk_handle_S&W.h"
#include "display.h"

uint8_t Color_RGB_Bit[24]; //洢24λɫ

/**
  * @brief:  Initialize the LED.
  * @param:  None
  * @retval: None
  */
void Led_init(void)
{
    gpio_init_t gpio_init_s;

    memset(&gpio_init_s, 0x0, sizeof(gpio_init_s));

    /* Enable the GPIO clock */
    ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);

    /* Config the LED pin */
    gpio_init_s.mode = GPIO_MODE_OUTPUT;
    gpio_init_s.odos = GPIO_PUSH_PULL;
    gpio_init_s.pupd = GPIO_PUSH_UP;
    gpio_init_s.podrv = GPIO_OUT_DRIVE_0_1;
    gpio_init_s.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_init_s.flt  = GPIO_FILTER_DISABLE;
    gpio_init_s.type = GPIO_TYPE_TTL;
    gpio_init_s.func = GPIO_FUNC_1;

#if TK_IOoutput_NUM > 0
    ald_gpio_init(TK_IOoutput_port0, TK_IOoutput_pin0, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 1
    ald_gpio_init(TK_IOoutput_port1, TK_IOoutput_pin1, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 2
    ald_gpio_init(TK_IOoutput_port2, TK_IOoutput_pin2, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 3
    ald_gpio_init(TK_IOoutput_port3, TK_IOoutput_pin3, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 4
    ald_gpio_init(TK_IOoutput_port4, TK_IOoutput_pin4, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 5
    ald_gpio_init(TK_IOoutput_port5, TK_IOoutput_pin5, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 6
    ald_gpio_init(TK_IOoutput_port6, TK_IOoutput_pin6, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 7
    ald_gpio_init(TK_IOoutput_port7, TK_IOoutput_pin7, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 8
    ald_gpio_init(TK_IOoutput_port8, TK_IOoutput_pin8, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 9
    ald_gpio_init(TK_IOoutput_port9, TK_IOoutput_pin9, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 10
    ald_gpio_init(TK_IOoutput_port10, TK_IOoutput_pin10, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 11
    ald_gpio_init(TK_IOoutput_port11, TK_IOoutput_pin11, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 12
    ald_gpio_init(TK_IOoutput_port12, TK_IOoutput_pin12, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 13
    ald_gpio_init(TK_IOoutput_port13, TK_IOoutput_pin13, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 14
    ald_gpio_init(TK_IOoutput_port14, TK_IOoutput_pin14, &gpio_init_s);
#endif
#if TK_IOoutput_NUM > 15
    ald_gpio_init(TK_IOoutput_port15, TK_IOoutput_pin15, &gpio_init_s);
#endif

    /* Lights out */
#if TK_IOoutput_NUM > 0
    ald_gpio_write_pin(TK_IOoutput_port0, TK_IOoutput_pin0, LED_Off);
#endif
#if TK_IOoutput_NUM > 1
    ald_gpio_write_pin(TK_IOoutput_port1, TK_IOoutput_pin1, LED_Off);
#endif
#if TK_IOoutput_NUM > 2
    ald_gpio_write_pin(TK_IOoutput_port2, TK_IOoutput_pin2, LED_Off);
#endif
#if TK_IOoutput_NUM > 3
    ald_gpio_write_pin(TK_IOoutput_port3, TK_IOoutput_pin3, LED_Off);
#endif
#if TK_IOoutput_NUM > 4
    ald_gpio_write_pin(TK_IOoutput_port4, TK_IOoutput_pin4, LED_Off);
#endif
#if TK_IOoutput_NUM > 5
    ald_gpio_write_pin(TK_IOoutput_port5, TK_IOoutput_pin5, LED_Off);
#endif
#if TK_IOoutput_NUM > 6
    ald_gpio_write_pin(TK_IOoutput_port6, TK_IOoutput_pin6, LED_Off);
#endif
#if TK_IOoutput_NUM > 7
    ald_gpio_write_pin(TK_IOoutput_port7, TK_IOoutput_pin7, LED_Off);
#endif
#if TK_IOoutput_NUM > 8
    ald_gpio_write_pin(TK_IOoutput_port8, TK_IOoutput_pin8, LED_Off);
#endif
#if TK_IOoutput_NUM > 9
    ald_gpio_write_pin(TK_IOoutput_port9, TK_IOoutput_pin9, LED_Off);
#endif
#if TK_IOoutput_NUM > 10
    ald_gpio_write_pin(TK_IOoutput_port10, TK_IOoutput_pin10, LED_Off);
#endif
#if TK_IOoutput_NUM > 11
    ald_gpio_write_pin(TK_IOoutput_port11, TK_IOoutput_pin11, LED_Off);
#endif
#if TK_IOoutput_NUM > 12
    ald_gpio_write_pin(TK_IOoutput_port12, TK_IOoutput_pin12, LED_Off);
#endif
#if TK_IOoutput_NUM > 13
    ald_gpio_write_pin(TK_IOoutput_port13, TK_IOoutput_pin13, LED_Off);
#endif
#if TK_IOoutput_NUM > 14
    ald_gpio_write_pin(TK_IOoutput_port14, TK_IOoutput_pin14, LED_Off);
#endif
#if TK_IOoutput_NUM > 15
    ald_gpio_write_pin(TK_IOoutput_port15, TK_IOoutput_pin15, LED_Off);
#endif
}

/**
  * @brief:  LED display.
  * @param:  None
  * @retval: None
  */
void TK_IO_output(uint32_t TK_state_temp)
{
    uint8_t i = 0;

#if TK_IOoutput_NUM > 0

    if (TK_state_temp & ((uint32_t)1 << i))
    {
        ald_gpio_write_pin(TK_IOoutput_port0, TK_IOoutput_pin0, LED_On);
    }
    else
    {
        ald_gpio_write_pin(TK_IOoutput_port0, TK_IOoutput_pin0, LED_Off);
    }

    i++;
#endif
#if TK_IOoutput_NUM > 1

    if (TK_state_temp & ((uint32_t)1 << i))
    {
        ald_gpio_write_pin(TK_IOoutput_port1, TK_IOoutput_pin1, LED_On);
    }
    else
    {
        ald_gpio_write_pin(TK_IOoutput_port1, TK_IOoutput_pin1, LED_Off);
    }

    i++;
#endif
#if TK_IOoutput_NUM > 2

    if (TK_state_temp & ((uint32_t)1 << i))
    {
        ald_gpio_write_pin(TK_IOoutput_port2, TK_IOoutput_pin2, LED_On);
    }
    else
    {
        ald_gpio_write_pin(TK_IOoutput_port2, TK_IOoutput_pin2, LED_Off);
    }

    i++;
#endif
#if TK_IOoutput_NUM > 3

    if (TK_state_temp & ((uint32_t)1 << i))
    {
        ald_gpio_write_pin(TK_IOoutput_port3, TK_IOoutput_pin3, LED_On);
    }
    else
    {
        ald_gpio_write_pin(TK_IOoutput_port3, TK_IOoutput_pin3, LED_Off);
    }

    i++;
#endif
#if TK_IOoutput_NUM > 4

    if (TK_state_temp & ((uint32_t)1 << i))
    {
        ald_gpio_write_pin(TK_IOoutput_port4, TK_IOoutput_pin4, LED_On);
    }
    else
    {
        ald_gpio_write_pin(TK_IOoutput_port4, TK_IOoutput_pin4, LED_Off);
    }

    i++;
#endif
#if TK_IOoutput_NUM > 5

    if (TK_state_temp & ((uint32_t)1 << i))
    {
        ald_gpio_write_pin(TK_IOoutput_port5, TK_IOoutput_pin5, LED_On);
    }
    else
    {
        ald_gpio_write_pin(TK_IOoutput_port5, TK_IOoutput_pin5, LED_Off);
    }

    i++;
#endif
#if TK_IOoutput_NUM > 6

    if (TK_state_temp & ((uint32_t)1 << i))
    {
        ald_gpio_write_pin(TK_IOoutput_port6, TK_IOoutput_pin6, LED_On);
    }
    else
    {
        ald_gpio_write_pin(TK_IOoutput_port6, TK_IOoutput_pin6, LED_Off);
    }

    i++;
#endif
//  #if TK_IOoutput_NUM > 7
//  if(TK_state_temp & ((uint32_t)1<<i)){ald_gpio_write_pin(TK_IOoutput_port7, TK_IOoutput_pin7, LED_On);}else{ald_gpio_write_pin(TK_IOoutput_port7, TK_IOoutput_pin7, LED_Off);}i++;
//  #endif
//  #if TK_IOoutput_NUM > 8
//  if(TK_state_temp & ((uint32_t)1<<i)){ald_gpio_write_pin(TK_IOoutput_port8, TK_IOoutput_pin8, LED_On);}else{ald_gpio_write_pin(TK_IOoutput_port8, TK_IOoutput_pin8, LED_Off);}i++;
//  #endif
//  #if TK_IOoutput_NUM > 9
//  if(TK_state_temp & ((uint32_t)1<<i)){ald_gpio_write_pin(TK_IOoutput_port9, TK_IOoutput_pin9, LED_On);}else{ald_gpio_write_pin(TK_IOoutput_port9, TK_IOoutput_pin9, LED_Off);}i++;
//  #endif
//  #if TK_IOoutput_NUM > 10
//  if(TK_state_temp & ((uint32_t)1<<i)){ald_gpio_write_pin(TK_IOoutput_port10, TK_IOoutput_pin10, LED_On);}else{ald_gpio_write_pin(TK_IOoutput_port10, TK_IOoutput_pin10, LED_Off);}i++;
//  #endif
//  #if TK_IOoutput_NUM > 11
//  if(TK_state_temp & ((uint32_t)1<<i)){ald_gpio_write_pin(TK_IOoutput_port11, TK_IOoutput_pin11, LED_On);}else{ald_gpio_write_pin(TK_IOoutput_port11, TK_IOoutput_pin11, LED_Off);}i++;
//  #endif
//  #if TK_IOoutput_NUM > 12
//  if(TK_state_temp & ((uint32_t)1<<i)){ald_gpio_write_pin(TK_IOoutput_port12, TK_IOoutput_pin12, LED_On);}else{ald_gpio_write_pin(TK_IOoutput_port12, TK_IOoutput_pin12, LED_Off);}i++;
//  #endif
//  #if TK_IOoutput_NUM > 13
//  if(TK_state_temp & ((uint32_t)1<<i)){ald_gpio_write_pin(TK_IOoutput_port13, TK_IOoutput_pin13, LED_On);}else{ald_gpio_write_pin(TK_IOoutput_port13, TK_IOoutput_pin13, LED_Off);}i++;
//  #endif
//  #if TK_IOoutput_NUM > 14
//  if(TK_state_temp & ((uint32_t)1<<i)){ald_gpio_write_pin(TK_IOoutput_port14, TK_IOoutput_pin14, LED_On);}else{ald_gpio_write_pin(TK_IOoutput_port14, TK_IOoutput_pin14, LED_Off);}i++;
//  #endif
//  #if TK_IOoutput_NUM > 15
//  if(TK_state_temp & ((uint32_t)1<<i)){ald_gpio_write_pin(TK_IOoutput_port15, TK_IOoutput_pin15, LED_On);}else{ald_gpio_write_pin(TK_IOoutput_port15, TK_IOoutput_pin15, LED_Off);}i++;
//  #endif
}

/**
  * @brief:  Set RGB data.
  * @param:  None
  * @retval: None
  */
void Set_Color(uint32_t Color_RGB)
{
    uint8_t i;

    for (i = 0; i < 24; i++)
    {
        if (Color_RGB & ((uint32_t)1 << i))
        {
            Color_RGB_Bit[23 - i] = 1;
        }
        else
        {
            Color_RGB_Bit[23 - i] = 0;
        }
    }
}

/**
  * @brief:  RGB LED display.
  * @param:  None
  * @retval: None
  */
void Send_24bitsData(uint8_t data_type)
{
    uint8_t i = 0;

    if (data_type)
    {
        for (i = 0; i < 24; i++)
        {
            if (Color_RGB_Bit[i])
            {
                Slider_Dis_1;
            }
            else
            {
                Slider_Dis_0;
            }
        }
    }
    else
    {
        for (i = 0; i < 24; i++)
        {
            if (Color_RGB_Bit[i])
            {
                Wheel_Dis_1;
            }
            else
            {
                Wheel_Dis_0;
            }
        }
    }
}

