/**
  *********************************************************************************
  *
  * @file    tkm_config.h
  * @brief   Header file for TK DEMO
  *
  * @version V1.0
  * @date    2 Dec 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
    *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#ifndef   __TK_CONFIG_H__
#define   __TK_CONFIG_H__

#define  TK_NUM                         18                          // ذ1--32

#define  TK_Channel_Sel                 0x03F8F07F                  // ÿһλӦҪʹõTKͨ

#define  TK_Channel0                    TK2         //Matrix
#define  TK_Channel1                    TK1
#define  TK_Channel2                    TK0
#define  TK_Channel3                    TK3
#define  TK_Channel4                    TK4
#define  TK_Channel5                    TK5
#define  TK_Channel6                    TK6
#define  TK_Channel7                    TK19        //Slider
#define  TK_Channel8                    TK20
#define  TK_Channel9                    TK21
#define  TK_Channel10                   TK22
#define  TK_Channel11                   TK23
#define  TK_Channel12                   TK24
#define  TK_Channel13                   TK25
#define  TK_Channel14                   TK12        //Wheel
#define  TK_Channel15                   TK13
#define  TK_Channel16                   TK14
#define  TK_Channel17                   TK15
#define  TK_Channel18                   TK9         //Button
#define  TK_Channel19                   TK10
#define  TK_Channel20                   TK11
#define  TK_Channel21                   TK21
#define  TK_Channel22                   TK22
#define  TK_Channel23                   TK23
#define  TK_Channel24                   TK24        // TK0--TK11  ظ ͬ
#define  TK_Channel25                   TK25
#define  TK_Channel26                   TK26
#define  TK_Channel27                   TK27
#define  TK_Channel28                   TK28
#define  TK_Channel29                   TK30
#define  TK_Channel30                   TK31

// Ӿ 30--3000  ָӰ Dltֵһ
#define  TK_Threshold_Channel0          25          //Matrix
#define  TK_Threshold_Channel1          25          //
#define  TK_Threshold_Channel2          25          //
#define  TK_Threshold_Channel3          25          //
#define  TK_Threshold_Channel4          25          //
#define  TK_Threshold_Channel5          25          //
#define  TK_Threshold_Channel6          25          //
#define  TK_Threshold_Channel7          50          //Slider
#define  TK_Threshold_Channel8          50          //
#define  TK_Threshold_Channel9          50          //
#define  TK_Threshold_Channel10         50          //
#define  TK_Threshold_Channel11         50          //
#define  TK_Threshold_Channel12         50          //
#define  TK_Threshold_Channel13         50          //
#define  TK_Threshold_Channel14         80          //Wheel
#define  TK_Threshold_Channel15         80          //
#define  TK_Threshold_Channel16         80          //
#define  TK_Threshold_Channel17         80          //
#define  TK_Threshold_Channel18         1000        //Button
#define  TK_Threshold_Channel19         1000        //
#define  TK_Threshold_Channel20         1000        //
#define  TK_Threshold_Channel21         100        //
#define  TK_Threshold_Channel22         100        //
#define  TK_Threshold_Channel23         100        //
#define  TK_Threshold_Channel24         100        // Ӿ 30--3000  ָӰ Dltֵһ
#define  TK_Threshold_Channel25         1000        //
#define  TK_Threshold_Channel26         1000        //
#define  TK_Threshold_Channel27         1000        //
#define  TK_Threshold_Channel28         1000        //
#define  TK_Threshold_Channel29         1000        //
#define  TK_Threshold_Channel30         1000        //

#define  TK_Matrix_Function             ON          /* ON  / OFF  󰴼֧*/
#define  TK_Matrix_Row_NUM              4

#define  TK_Matrix_Row0                 TK_Ch3      /*2--24*/
#define  TK_Matrix_Row1                 TK_Ch4
#define  TK_Matrix_Row2                 TK_Ch5
#define  TK_Matrix_Row3                 TK_Ch6

#define  TK_Matrix_Column_NUM           3

#define  TK_Matrix_Column0              TK_Ch0      /*2--24*/
#define  TK_Matrix_Column1              TK_Ch1
#define  TK_Matrix_Column2              TK_Ch2

#define  TK_Slider_Function             ON          /* ON  / OFF ܿ*/
#define  TK_Slider_Levels               7           /*2--24   Sensor num ɼSensorɵSlider*/
#define  TK_Slider_poles_setting        17          /*Value <= TK_Slider_poles_setting* (TK_Slider_Levels-1)*/

#define  TK_Slider_level0               TK_Ch7
#define  TK_Slider_level1               TK_Ch8
#define  TK_Slider_level2               TK_Ch9
#define  TK_Slider_level3               TK_Ch10
#define  TK_Slider_level4               TK_Ch11
#define  TK_Slider_level5               TK_Ch12
#define  TK_Slider_level6               TK_Ch13

#define  TK_Wheel_Function              ON          /* ON  / OFF */
#define  TK_Wheel_Levels                4           /*2--24   Sensor num*/
#define  TK_Wheel_poles_setting         25          /*<=32* TK_Wheel_Levels*/

#define  TK_Wheel_level0                TK_Ch14
#define  TK_Wheel_level1                TK_Ch15
#define  TK_Wheel_level2                TK_Ch16
#define  TK_Wheel_level3                TK_Ch17

#define  TK_Singlepress                 OFF                         /*ON/OFF ͬһ̽һǿ ʵʰѹ3  OFF аͬʱ*/
#define  TK_Mult_inhibition             0                           /*0---5  ټϵ 0   1 50% 225%  312.5% 46.25%   ڽָѹټ*/
#define  TK_Samples_perscan             3                           /*ۼ趨1--16 16λ*/
#define  TK_Threshold_release           9                           /*0.4-0.9 ɿ趨0.530ɿҪ15  5==50%*/
#define  TK_BaseSamples_perscan         30*(32-TK_NUM)              /*߸ 趨1--65535*/
#define  TK_Press_timeout               (10*100)                    /*10s ʱǿȡ˰״̬ƽ 125--65535*/
#define  TK_Debounce_press              10                          /*µĴ趨*/
#define  TK_Debounce_release            5                           /*뿪Ĵ趨*/
#define  Jitter_level1_Threshold        TK_Threshold_Channel0*1.5*TK_NUM											/*When more than this  value use a specilize filter  base was locked    Type value  SUM(TK_Threshold_Channeln,n=0~TK_NUM-1)*0.3*/
#define  Jitter_level2_Threshold        TK_Threshold_Channel0*3*TK_NUM                        /*When more than this  value use a specilize filter  base was locked    Type value  SUM(TK_Threshold_Channeln,n=0~TK_NUM-1)*0.3*/
#define  Auto_Jitter_software           OFF                         /*Ƶ,ùʹȥȥС*/
#define  Auto_Jitter_hardware           OFF                         /*ӲƵ,ùʹȥȥС*/
#define  TK_Guardsensor_output          OFF                         /*SNR*/
#define  Max_Minvalueoff_filter         ON                          /*ON/ OFF ȥСֵ*/
#define  Jitter_Function                OFF                         /*ݴ*/
#define  Jitter_tolerance               0                           /*0 --5  ݴ趨*/
#define  TK_Amplifi_setting             0x000FFFFF                  /*TK Ŵϵ趨  1-0x0FFFFFFF*/
#define  Timercounter_10ms              80                          /*ʱ10MS 80*/
#define  TK_Lowpowermode                OFF                         /*ON/ OFF   When ON make sure you had opened the TK_MODE2 ON And WDT was opend on Config word*/
#define  TK_LP_dataprocess_mode         Merge                       /*Merge/Poll*/
#define  TK_LPtimer_sleepsetting        LPtimer_300ms               /*ms  50/100/200/300/400/500*/
#define  TK_Mode0_nokeytoswitch_time    (10*100)                    /*10s  0--65535  Mode0 no key press time to switch Mode2*/
#define  TK_Sleep_Threshold             100                         /**/

/*  */
/**********************************************************************************************************************************/
#define  TK_NUM_LP                      TK_NUM                              // ذ1--20

#define  TK_reg_TKSEL_LP                TK_Channel_Sel                      // ÿһλӦҪʹõTKͨ

#define  TK_Channel0_LP                 TK_Channel0                         // ظ ͬ
#define  TK_Channel1_LP                 TK_Channel1
#define  TK_Channel2_LP                 TK_Channel2
#define  TK_Channel3_LP                 TK_Channel3
#define  TK_Channel4_LP                 TK_Channel4
#define  TK_Channel5_LP                 TK_Channel5
#define  TK_Channel6_LP                 TK_Channel6
#define  TK_Channel7_LP                 TK_Channel7
#define  TK_Channel8_LP                 TK_Channel8
#define  TK_Channel9_LP                 TK_Channel9
#define  TK_Channel10_LP                TK_Channel10
#define  TK_Channel11_LP                TK_Channel11
#define  TK_Channel12_LP                TK_Channel12
#define  TK_Channel13_LP                TK_Channel13
#define  TK_Channel14_LP                TK_Channel14
#define  TK_Channel15_LP                TK_Channel15
#define  TK_Channel16_LP                TK_Channel16
#define  TK_Channel17_LP                TK_Channel17
#define  TK_Channel18_LP                TK_Channel18
#define  TK_Channel19_LP                TK_Channel19
#define  TK_Channel20_LP                TK_Channel20
#define  TK_Channel21_LP                TK_Channel21
#define  TK_Channel22_LP                TK_Channel22
#define  TK_Channel23_LP                TK_Channel23
#define  TK_Channel24_LP                TK_Channel24
#define  TK_Channel25_LP                TK_Channel25
#define  TK_Channel26_LP                TK_Channel26
#define  TK_Channel27_LP                TK_Channel27
#define  TK_Channel28_LP                TK_Channel28
#define  TK_Channel29_LP                TK_Channel30
#define  TK_Channel30_LP                TK_Channel31

#define  TK_Threshold_Channel0_LP       TK_Threshold_Channel0                                 // Ӿ 30--3000  ָӰ Dltֵһ
#define  TK_Threshold_Channel1_LP       TK_Threshold_Channel1
#define  TK_Threshold_Channel2_LP       TK_Threshold_Channel2
#define  TK_Threshold_Channel3_LP       TK_Threshold_Channel3
#define  TK_Threshold_Channel4_LP       TK_Threshold_Channel4
#define  TK_Threshold_Channel5_LP       TK_Threshold_Channel5
#define  TK_Threshold_Channel6_LP       TK_Threshold_Channel6
#define  TK_Threshold_Channel7_LP       TK_Threshold_Channel7
#define  TK_Threshold_Channel8_LP       TK_Threshold_Channel8
#define  TK_Threshold_Channel9_LP       TK_Threshold_Channel9
#define  TK_Threshold_Channel10_LP      TK_Threshold_Channel10
#define  TK_Threshold_Channel11_LP      TK_Threshold_Channel11
#define  TK_Threshold_Channel12_LP      TK_Threshold_Channel12
#define  TK_Threshold_Channel13_LP      TK_Threshold_Channel13
#define  TK_Threshold_Channel14_LP      TK_Threshold_Channel14
#define  TK_Threshold_Channel15_LP      TK_Threshold_Channel15
#define  TK_Threshold_Channel16_LP      TK_Threshold_Channel16
#define  TK_Threshold_Channel17_LP      TK_Threshold_Channel17
#define  TK_Threshold_Channel18_LP      TK_Threshold_Channel18
#define  TK_Threshold_Channel19_LP      TK_Threshold_Channel19
#define  TK_Threshold_Channel20_LP      TK_Threshold_Channel20
#define  TK_Threshold_Channel21_LP      TK_Threshold_Channel21
#define  TK_Threshold_Channel22_LP      TK_Threshold_Channel22
#define  TK_Threshold_Channel23_LP      TK_Threshold_Channel23
#define  TK_Threshold_Channel24_LP      TK_Threshold_Channel24
#define  TK_Threshold_Channel25_LP      TK_Threshold_Channel25
#define  TK_Threshold_Channel26_LP      TK_Threshold_Channel26
#define  TK_Threshold_Channel27_LP      TK_Threshold_Channel27
#define  TK_Threshold_Channel28_LP      TK_Threshold_Channel28
#define  TK_Threshold_Channel29_LP      TK_Threshold_Channel29
#define  TK_Threshold_Channel30_LP      TK_Threshold_Channel30

#define  TK_UARToutput_function         ON                  // ON/ OFF
#define  TK_UART_TYPE                   TKM_UART            // TKM_UART/TKM_USART/TKM_LPUART
#define  TK_UARToutput_Baudrate         115200              // 115200  57600 38400 19200 .......9600

//TK_advance
#define  TK_reg_CON0                    0x00508519          // 2M
#define  TK_reg_CON0_bk1                0x00308519          // 4M
#define  TK_reg_CON0_bk2                0x00708519          // 1M
#define  TK_reg_CON1                    0x6038047B          // 2.3V
#define  TK_reg_SFJTR                   0//0x01000000       //0x00010505 //΢Ƶ 2M

#define  TK_reg_CON0_merge              0x00528508          // 2M
#define  TK_reg_CON0_poll               0x00528518          // 2M
#define  TK_reg_CON1_sleep              0x6038047B          // 2.3V

#define  TK_IOoutput_function           ON                  // ON/ OFF     
#define  TK_IOoutput_NUM                9                   // 1--16
#define  TK_IOLED_Function              Indicate            // Indicate/Toggle ɿ ǿشģʽ

#define  TK_IOoutput_port0              GPIOC                       //Matrix
#define  TK_IOoutput_port1              GPIOC
#define  TK_IOoutput_port2              GPIOB
#define  TK_IOoutput_port3              GPIOA
#define  TK_IOoutput_port4              GPIOB                       //Button
#define  TK_IOoutput_port5              GPIOA
#define  TK_IOoutput_port6              GPIOA
#define  TK_IOoutput_port7              GPIOC                       //Slider
#define  TK_IOoutput_port8              GPIOC                       //Wheel
#define  TK_IOoutput_port9              GPIOA
#define  TK_IOoutput_port10             GPIOA
#define  TK_IOoutput_port11             GPIOA
#define  TK_IOoutput_port12             GPIOA
#define  TK_IOoutput_port13             GPIOA
#define  TK_IOoutput_port14             GPIOA
#define  TK_IOoutput_port15             GPIOA

#define  TK_IOoutput_pin0               GPIO_PIN_6              //Matrix        
#define  TK_IOoutput_pin1               GPIO_PIN_5
#define  TK_IOoutput_pin2               GPIO_PIN_0
#define  TK_IOoutput_pin3               GPIO_PIN_7
#define  TK_IOoutput_pin4               GPIO_PIN_15             //Button
#define  TK_IOoutput_pin5               GPIO_PIN_8
#define  TK_IOoutput_pin6               GPIO_PIN_9
#define  TK_IOoutput_pin7               GPIO_PIN_9              //Slider
#define  TK_IOoutput_pin8               GPIO_PIN_8              //Wheel
#define  TK_IOoutput_pin9               GPIO_PIN_8
#define  TK_IOoutput_pin10              GPIO_PIN_8
#define  TK_IOoutput_pin11              GPIO_PIN_8
#define  TK_IOoutput_pin12              GPIO_PIN_8
#define  TK_IOoutput_pin13              GPIO_PIN_8
#define  TK_IOoutput_pin14              GPIO_PIN_8
#define  TK_IOoutput_pin15              GPIO_PIN_8

#define  LPtimer_50ms                   0x1F4
#define  LPtimer_100ms                  0x3E8
#define  LPtimer_200ms                  0x7D0
#define  LPtimer_300ms                  0xBB8
#define  LPtimer_400ms                  0xFA0
#define  LPtimer_500ms                  0x1388

#define  IWDT_function                  ON                      // ON/OFF 
#define  IWDT_10ms                      0x140
#define  IWDT_50ms                      0x640
#define  IWDT_100ms                     0xC80
#define  IWDT_200ms                     0x1900
#define  IWDT_300ms                     0x2580
#define  IWDT_400ms                     0x3200
#define  IWDT_500ms                     0x3E80
#define  IWDT_1s                        0x7D00
#define  IWDT_2s                        0xFA00
#define  IWDT_3s                        0x17700
#define  IWDT_4s                        0x1F400
#define  IWDT_5s                        0x27100

#define  TK0                            0                   // PA0
#define  TK1                            1                   // PA1
#define  TK2                            2                   // PA2
#define  TK3                            3                   // PA3
#define  TK4                            4                   // PA4
#define  TK5                            5                   // PA5
#define  TK6                            6                   // PA6
#define  TK7                            7                   // PA7  
#define  TK8                            8                   // PB0
#define  TK9                            9                   // PB1
#define  TK10                           10                  // PB2
#define  TK11                           11                  // PB10
#define  TK12                           12                  // PB11
#define  TK13                           13                  // PB12
#define  TK14                           14                  // PB13
#define  TK15                           15                  // PB14
#define  TK16                           16                  // PB15
#define  TK17                           17                  // PA8
#define  TK18                           18                  // PA9
#define  TK19                           19                  // PA10
#define  TK20                           20                  // PA11
#define  TK21                           21                  // PA12
#define  TK22                           22                  // PA15
#define  TK23                           23                  // PB3
#define  TK24                           24                  // PB4
#define  TK25                           25                  // PB5
#define  TK26                           26                  // PB6
#define  TK27                           27                  // PB7
#define  TK28                           28                  // PB9
#define  TK30                           30                  // PC3
#define  TK31                           31                  // PC4

#define  TK_Ch0                         0
#define  TK_Ch1                         1
#define  TK_Ch2                         2
#define  TK_Ch3                         3
#define  TK_Ch4                         4
#define  TK_Ch5                         5
#define  TK_Ch6                         6
#define  TK_Ch7                         7
#define  TK_Ch8                         8
#define  TK_Ch9                         9
#define  TK_Ch10                        10
#define  TK_Ch11                        11
#define  TK_Ch12                        12
#define  TK_Ch13                        13
#define  TK_Ch14                        14
#define  TK_Ch15                        15
#define  TK_Ch16                        16
#define  TK_Ch17                        17
#define  TK_Ch18                        18
#define  TK_Ch19                        19
#define  TK_Ch20                        20
#define  TK_Ch21                        21
#define  TK_Ch22                        22
#define  TK_Ch23                        23
#define  TK_Ch24                        24
#define  TK_Ch25                        25
#define  TK_Ch26                        26
#define  TK_Ch27                        27
#define  TK_Ch28                        28
#define  TK_Ch30                        30
#define  TK_Ch31                        31

#define  ON                             1
#define  OFF                            0
#define  LED_On                         1
#define  LED_Off                        0
#define  Toggle                         1
#define  Indicate                       0
#define  Merge                          1
#define  Poll                           0
#define  Slider_type                    1
#define  Wheel_type                     0
#define  TKM_UART                       1
#define  TKM_USART                      2
#define  TKM_LPUART                     3
/************************************************************************************************************************************/

#endif
