/**
  *********************************************************************************
  *
  * @file    tk_handle_S&W.h
  * @brief   Header file for TK DEMO
  *
  * @version V1.0
  * @date    2 Dec 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
    *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#ifndef   __TK_HANDLE_H__
#define   __TK_HANDLE_H__

#include "stdint.h"

typedef struct
{
    uint16_t tk_value_origin;     // Origin      data
    uint16_t tk_value_filter;     // Filter      data
    uint16_t tk_value_average;    // Base line   data
    uint16_t tk_timeout_counter;  // For TK press time counter
    uint8_t tk_press_table;       // For press    counter
    uint8_t tk_release_table;     // For release  counter
    uint16_t tk_D_value;          // Base line   data - Filter data
#if  Max_Minvalueoff_filter == ON
    uint16_t tk_value_max;        // Origin Max     data
    uint16_t tk_value_min;        // Origin Min     data
#endif
} TKValueStru;

extern TKValueStru TK_Value_Arr[];
extern TKValueStru curr_tk_value;

#if Jitter_Function == ON
    extern uint8_t TK_Jitter_tolerance[];
#endif
extern uint8_t TK_value_get;                    //Temp value flag after scan complete
extern uint8_t Lock_averageconter;              //lock average flag
extern uint8_t Lock_averageconter2;             //lock average flag
extern uint32_t  TKS_CON0_ram;
extern uint8_t Tkscan_numth;                    //current processing TK channel
extern uint8_t Tkscan_sampcounter;              //sampling count
extern uint8_t Timer_counter;                   //TK run timeout count
extern uint16_t TK_Base_percounter;             //baseline update count
extern uint16_t Opr_state;                      //state machine of TK
extern uint16_t TK_value;                       //Temp value after scan
extern uint16_t TK_jitter_Value;                //maximum and minimum differences
extern uint32_t TK_state;                       //the key state
extern uint32_t TK_state_single;                //maximum key state
extern uint32_t  TK_state_bk;                   //for backup
extern const uint8_t Channel_table[];           //Channel table for use as tk channel
extern const uint8_t Channel_table_LP[];
extern const uint16_t Threshold_table[];        //Threshold table for tk channel
extern const uint16_t Threshold_table_LP[];

//for TK lib
extern uint8_t TK_chnum;
extern const uint8_t DF_TK_Singlepress;
extern const uint32_t DF_TK_reg_CON0;
extern const uint32_t DF_TK_reg_CON0_bk1;

//#if  TK_Matrix_Function == ON
extern uint16_t  TK_D_Rvalue[];             // D value  data to see if which one is the most one
extern uint16_t  TK_D_Cvalue[];             // D value  data to see if which one is the most one
extern uint32_t  TK_Matrix_RID;
extern uint32_t  TK_Matrix_CID;
extern uint16_t  TK_Matrix_value;
extern uint8_t   Matrix_timer;                                  // Time to clear
extern const uint8_t Channel_MatrixRowtable[];
extern const uint8_t Channel_MatrixColumetable[];
extern const uint8_t DF_TK_Matrix_Row_NUM;
extern const uint8_t DF_TK_Matrix_Column_NUM;
//#endif

//#if  TK_Slider_Function == ON
extern int TK_D_slider[];         // D value  data to see if which one is the most one
extern uint32_t TK_slider_ID;
extern uint16_t  TK_slider_value;
extern uint8_t Slider_timer;                             // Time to clear
extern const uint8_t Channel_Slidertable[];
extern const uint8_t DF_TK_Slider_Levels;
extern const uint8_t DF_TK_Slider_poles_setting;
//#endif

//#if  TK_Wheel_Function == ON
extern int  TK_D_wheel[];                                     // D value  data to see if which one is the most one
extern uint32_t TK_wheel_ID;
extern uint16_t  TK_wheel_value;
extern uint8_t Wheel_timer;                                     // Time to clear
extern const uint8_t Channel_Wheeltable[];
extern const uint8_t DF_TK_Wheel_Levels;
extern const uint8_t DF_TK_Wheel_poles_setting;
//#endif

extern void proc_curr_tk_value(uint8_t idx, uint8_t direct);
extern void TK_Init(void);      //TKʼ
//extern void Tk_getbaselinedata(void);
extern void Tk_service(void);
extern void Timer_check(void);
extern void Update_TKdata(void);
extern void Singlekeyprocess(void);
extern void Matrix_process(void);
extern void Customer_Matrixvalue_justrefreshed(void);
extern void Slider_process(void);
extern void Customer_Slidervalue_justrefreshed(void);
extern void Wheel_process(void);
extern void Customer_Wheelvalue_justrefreshed(void);
extern uint8_t Mult_inhibition(uint16_t Dlt_data, uint8_t Inhibition_data);
extern void Force_average(uint8_t num_th);
extern uint16_t DataFilter(uint16_t Origin, uint16_t Befilter);
extern uint16_t DataJitter(void);
extern void Software_jitterprocess(uint16_t Jitter_ram, uint16_t Jitter_level1_ram, uint16_t Jitter_level2_ram);

#endif
