/**
  *********************************************************************************
  *
  * @file    display.h
  * @brief   Header file for TK DEMO
  *
  * @version V1.0
  * @date    2 Dec 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
    *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#ifndef   __DISPLAY_H__
#define   __DISPLAY_H__

#include "stdint.h"

//--------------------G R B---/
#define  RED                0x00ff00
#define  GREEN              0xff0000
#define  BLUE               0x0000ff
#define  YELLOW             0xffff00
#define  PINK               0x00ffff
#define  WATHET             0xff00ff
#define  WHITE              0XFFFFFF
#define  BLACK              0X000000

#define  NOP1()             __nop()
#define  NOP2()             NOP1();NOP1()
#define  NOP5()             NOP2();NOP2();NOP1()
#define  NOP10()            NOP5();NOP5()
#define  NOP20()            NOP10();NOP10()

#define  Slider_Port_1      GPIOC->DOUT |= GPIO_PIN_9
#define  Slider_Port_0      GPIOC->DOUT &= ~GPIO_PIN_9

#define  Wheel_Port_1       GPIOC->DOUT |= GPIO_PIN_8
#define  Wheel_Port_0       GPIOC->DOUT &= ~GPIO_PIN_8

#define  Slider_Dis_0       Slider_Port_1; Slider_Port_0
#define  Slider_Dis_1       Slider_Port_1; NOP2(); NOP2(); NOP1(); Slider_Port_0

#define  Wheel_Dis_0        Wheel_Port_1; Wheel_Port_0
#define  Wheel_Dis_1        Wheel_Port_1; NOP2(); NOP2(); NOP1(); Wheel_Port_0

extern uint8_t Color_RGB_Bit[24]; //洢24λɫ

extern void Led_init(void);
extern void TK_IO_output(uint32_t TK_state_temp);
extern void Set_Color(uint32_t Color_RGB);
extern void Send_24bitsData(uint8_t data_type);

#endif
