/**
  *********************************************************************************
  *
  * @file    timer.c
  * @brief   timer file for TK DEMO
  *
  * @version V1.1
  * @date    18 May 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
  *          18 May 2023     AE Team         Enable TK interrupt
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#include <string.h>
#include "ald_cmu.h"
#include "ald_timer.h"
#include "timer.h"
#include "tkm_config.h"
#include "tk_handle.h"
#include "tk_low_power.h"

uint8_t Timer_10ms;
timer_handle_t h_tim1;

/**
  * @brief  period elapsed call back.
  * @param  arg: Pointer to timer_handle_s structure.
  * @retval None
  */
void ald_timer_periodelapsedcallback(struct timer_handle_s *arg)
{
    Timer_10ms++;
}

/**
  * @brief  Initializate BS16T0.
  * @retval None
  */
void BS16T0_Init(void)
{
    timer_clock_config_t tim_clock;

    memset(&h_tim1, 0x0, sizeof(h_tim1));
    memset(&tim_clock, 0x0, sizeof(tim_clock));

    ald_cmu_perh_clock_config(CMU_PERH_BS16T0, ENABLE);
    /* Initialize BS16T0 */
    h_tim1.perh = BS16T0;
    h_tim1.init.prescaler    = 47;
    h_tim1.init.mode         = TIMER_CNT_MODE_UP;
    h_tim1.init.period       = 10000; //10ms
    h_tim1.init.clk_div      = TIMER_CLOCK_DIV1;
    h_tim1.init.re_cnt       = 0;
    h_tim1.period_elapse_cbk = ald_timer_periodelapsedcallback;
    ald_timer_base_init(&h_tim1);

    /* Initialize clock source */
    tim_clock.source = TIMER_SRC_INTER;
    ald_timer_config_clock_source(&h_tim1, &tim_clock);

    /* Enable BS16T0 interrupt */
    ald_mcu_irq_config(BS16T0_IRQn, 2, ENABLE);

    /* Enable UPDATE interrupt */
    ald_timer_interrupt_config(&h_tim1, TIMER_IT_UPDATE, ENABLE);

    /* Start input pwm from BS16T0 channel 1 */
    ald_timer_base_start(&h_tim1);
}
