/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.2
  * @date    18 May 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
  *          29 Dec 2022     AE Team         Add serial port options
  *          18 May 2023     AE Team         Enable TK interrupt
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#include "ald_cmu.h"
#include "ald_tks.h"
#include "timer.h"
#include "tk_uart.h"
#include "tk_low_power.h"
#include "tk_handle.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    ald_inc_tick();
    return;
}

/**
  * @brief  CMU IRQ#6 handler
  * @retval None
  */
void CMU_Handler(void)
{
    ald_cmu_irq_handler();
    return;
}

#ifdef ALD_DMA
/**
  * @brief  DMA IRQ#66 handler
  * @retval None
  */
void DMA_Handler(void)
{
    ald_dma_irq_handler();
}
#endif

/**
  * @brief  BS16T0 IRQ handler
  * @retval None
  */
void BS16T0_Handler(void)
{
    /* Handle TIM interrupt */
    ald_timer_irq_handler(&h_tim1);
    return;
}

#if TK_UARToutput_function == ON
#if TK_UART_TYPE == TKM_UART
/**
  * @brief  UART IRQ handler
  * @retval None
  */
void UART0_Handler(void)
{
    /* Handle uart interrupt */
    ald_uart_irq_handler(&h_uart_tk);
    return;
}
#endif
#if TK_UART_TYPE == TKM_USART
/**
  * @brief  USART0 handler
  * @retval None
  */
void USART0_Handler(void)
{
    ald_usart_irq_handler(&h_usart0_tk);
    return;
}
#endif
#if TK_UART_TYPE == TKM_LPUART
/**
  * @brief  LPUART IRQ handler
  * @retval None
  */
void LPUART0_Handler(void)
{
    /* Handle uart interrupt */
    ald_lpuart_irq_handler(&h_lpuart_tk);
    return;
}
#endif
#endif

#if TK_Lowpowermode == ON
/**
  * @brief  LP16T0 IRQ handler
  * @retval None
  */
void LP16T0_Handler(void)
{
    ald_lptim_irq_handler(&h_lptim);
}
#endif

/**
  * @brief  LP16T0 IRQ handler
  * @retval None
  */
void TKS_Handler(void)
{
    if (TKS->IF)
    {
        if (TKS->IF & 0x00000010)
        {
            Timer_counter = 0;             //Clear Measure time for tk module
            TK_value_get = 1;              //Set a flag for TK_value  update
        }
        else
        {
            TK_value_get = 0;
        }

#if Auto_Jitter_software == ON

        if (Lock_averageconter > 2)
        {
            if (0x00700000 != (TKS->CON0 & 0x00F00000))
            {
                TKS->CON0 &= ~0x00F00000;
                TKS->CON0 |= 0x00700000; //ı乤ƵΪ1MHz
            }
        }
        else
        {
            if (0x00500000 != (TKS->CON0 & 0x00F00000))
            {
                TKS->CON0 &= ~0x00F00000;
                TKS->CON0 |= 0x00500000; //ı乤ƵΪ2MHz
            }
        }

#endif
//          TKS_CON0_ram &= 0x00F00000;  // Clear other bits
//          TKS_CON0_ram |= (TKS->CON0 & 0xFF0FFFFF); // Keep other bits
//          TKS->CON0 = TKS_CON0_ram;     //

        TKS->IFC |= 0x0000001F;          // ж

        if (TK_value_get == 0)
        {
#if TK_Lowpowermode == ON

            if (g_wakeup_flag != 2)
#endif
            {
                TKS->CON0 |= 0x00000002;                            // ʹܴʹģ飬TKGO = 1ɨ
            }
        }
    }
}

/**
  * @}
  */
/**
  * @}
  */
