/**
  *********************************************************************************
  *
  * @file    tk_handle.c
  * @brief   TK Data Process
  *
  * @version V1.2
  * @date    18 Oct 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
  *          29 Dec 2022     AE Team         Add serial port options
  *          18 Oct 2023     AE Team         Modify the baseline processing mode after power-on
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#include <string.h>
#include "tkm_config.h"
#include "tk_handle.h"
#include "tk_low_power.h"
#include "timer.h"
#include "tk_uart.h"
#include "customer.h"

uint32_t pow_ulong(uint8_t i)
{
    return ((uint32_t)1 << i);
}

const uint8_t Channel_table[TK_NUM] =     // Channel table for use as tk channel
{
#if TK_NUM >0
    TK_Channel0
#endif
#if TK_NUM >1
    , TK_Channel1
#endif
#if TK_NUM >2
    , TK_Channel2
#endif
#if TK_NUM >3
    , TK_Channel3
#endif
#if TK_NUM >4
    , TK_Channel4
#endif
#if TK_NUM >5
    , TK_Channel5
#endif
#if TK_NUM >6
    , TK_Channel6
#endif
#if TK_NUM >7
    , TK_Channel7
#endif
#if TK_NUM >8
    , TK_Channel8
#endif
#if TK_NUM >9
    , TK_Channel9
#endif
#if TK_NUM >10
    , TK_Channel10
#endif
#if TK_NUM >11
    , TK_Channel11
#endif
#if TK_NUM >12
    , TK_Channel12
#endif
#if TK_NUM >13
    , TK_Channel13
#endif
#if TK_NUM >14
    , TK_Channel14
#endif
#if TK_NUM >15
    , TK_Channel15
#endif
#if TK_NUM >16
    , TK_Channel16
#endif
#if TK_NUM >17
    , TK_Channel17
#endif
#if TK_NUM >18
    , TK_Channel18
#endif
#if TK_NUM >19
    , TK_Channel19
#endif
#if TK_NUM >20
    , TK_Channel20
#endif
#if TK_NUM >21
    , TK_Channel21
#endif
#if TK_NUM >22
    , TK_Channel22
#endif
#if TK_NUM >23
    , TK_Channel23
#endif
#if TK_NUM >24
    , TK_Channel24
#endif
#if TK_NUM >25
    , TK_Channel25
#endif
#if TK_NUM >26
    , TK_Channel26
#endif
#if TK_NUM >27
    , TK_Channel27
#endif
#if TK_NUM >28
    , TK_Channel28
#endif
#if TK_NUM >29
    , TK_Channel29
#endif
#if TK_NUM >30
    , TK_Channel30
#endif
};

const uint8_t Channel_table_LP[TK_NUM_LP] =     // Channel table for use as tk channel
{
#if TK_NUM_LP >0
    TK_Channel0_LP
#endif
#if TK_NUM_LP >1
    , TK_Channel1_LP
#endif
#if TK_NUM_LP >2
    , TK_Channel2_LP
#endif
#if TK_NUM_LP >3
    , TK_Channel3_LP
#endif
#if TK_NUM_LP >4
    , TK_Channel4_LP
#endif
#if TK_NUM_LP >5
    , TK_Channel5_LP
#endif
#if TK_NUM_LP >6
    , TK_Channel6_LP
#endif
#if TK_NUM_LP >7
    , TK_Channel7_LP
#endif
#if TK_NUM_LP >8
    , TK_Channel8_LP
#endif
#if TK_NUM_LP >9
    , TK_Channel9_LP
#endif
#if TK_NUM_LP >10
    , TK_Channel10_LP
#endif
#if TK_NUM_LP >11
    , TK_Channel11_LP
#endif
#if TK_NUM_LP >12
    , TK_Channel12_LP
#endif
#if TK_NUM_LP >13
    , TK_Channel13_LP
#endif
#if TK_NUM_LP >14
    , TK_Channel14_LP
#endif
#if TK_NUM_LP >15
    , TK_Channel15_LP
#endif
#if TK_NUM_LP >16
    , TK_Channel16_LP
#endif
#if TK_NUM_LP >17
    , TK_Channel17_LP
#endif
#if TK_NUM_LP >18
    , TK_Channel18_LP
#endif
#if TK_NUM_LP >19
    , TK_Channel19_LP
#endif
#if TK_NUM_LP >20
    , TK_Channel20_LP
#endif
#if TK_NUM_LP >21
    , TK_Channel21_LP
#endif
#if TK_NUM_LP >22
    , TK_Channel22_LP
#endif
#if TK_NUM_LP >23
    , TK_Channel23_LP
#endif
#if TK_NUM_LP >24
    , TK_Channel24_LP
#endif
#if TK_NUM_LP >25
    , TK_Channel25_LP
#endif
#if TK_NUM_LP >26
    , TK_Channel26_LP
#endif
#if TK_NUM_LP >27
    , TK_Channel27_LP
#endif
#if TK_NUM_LP >28
    , TK_Channel28_LP
#endif
#if TK_NUM_LP >29
    , TK_Channel29_LP
#endif
#if TK_NUM_LP >30
    , TK_Channel30_LP
#endif
};

const uint16_t Threshold_table[TK_NUM] =    // Threshold table for tk channel
{
#if TK_NUM >0
    TK_Threshold_Channel0
#endif
#if TK_NUM >1
    , TK_Threshold_Channel1
#endif
#if TK_NUM >2
    , TK_Threshold_Channel2
#endif
#if TK_NUM >3
    , TK_Threshold_Channel3
#endif
#if TK_NUM >4
    , TK_Threshold_Channel4
#endif
#if TK_NUM >5
    , TK_Threshold_Channel5
#endif
#if TK_NUM >6
    , TK_Threshold_Channel6
#endif
#if TK_NUM >7
    , TK_Threshold_Channel7
#endif
#if TK_NUM >8
    , TK_Threshold_Channel8
#endif
#if TK_NUM >9
    , TK_Threshold_Channel9
#endif
#if TK_NUM >10
    , TK_Threshold_Channel10
#endif
#if TK_NUM >11
    , TK_Threshold_Channel11
#endif
#if TK_NUM >12
    , TK_Threshold_Channel12
#endif
#if TK_NUM >13
    , TK_Threshold_Channel13
#endif
#if TK_NUM >14
    , TK_Threshold_Channel14
#endif
#if TK_NUM >15
    , TK_Threshold_Channel15
#endif
#if TK_NUM >16
    , TK_Threshold_Channel16
#endif
#if TK_NUM >17
    , TK_Threshold_Channel17
#endif
#if TK_NUM >18
    , TK_Threshold_Channel18
#endif
#if TK_NUM >19
    , TK_Threshold_Channel19
#endif
#if TK_NUM >20
    , TK_Threshold_Channel20
#endif
#if TK_NUM >21
    , TK_Threshold_Channel21
#endif
#if TK_NUM >22
    , TK_Threshold_Channel22
#endif
#if TK_NUM >23
    , TK_Threshold_Channel23
#endif
#if TK_NUM >24
    , TK_Threshold_Channel24
#endif
#if TK_NUM >25
    , TK_Threshold_Channel25
#endif
#if TK_NUM >26
    , TK_Threshold_Channel26
#endif
#if TK_NUM >27
    , TK_Threshold_Channel27
#endif
#if TK_NUM >28
    , TK_Threshold_Channel28
#endif
#if TK_NUM >29
    , TK_Threshold_Channel29
#endif
#if TK_NUM >30
    , TK_Threshold_Channel30
#endif
};

const uint16_t Threshold_table_LP[TK_NUM_LP] =    // Threshold table for tk channel
{
#if TK_NUM_LP >0
    TK_Threshold_Channel0_LP
#endif
#if TK_NUM_LP >1
    , TK_Threshold_Channel1_LP
#endif
#if TK_NUM_LP >2
    , TK_Threshold_Channel2_LP
#endif
#if TK_NUM_LP >3
    , TK_Threshold_Channel3_LP
#endif
#if TK_NUM_LP >4
    , TK_Threshold_Channel4_LP
#endif
#if TK_NUM_LP >5
    , TK_Threshold_Channel5_LP
#endif
#if TK_NUM_LP >6
    , TK_Threshold_Channel6_LP
#endif
#if TK_NUM_LP >7
    , TK_Threshold_Channel7_LP
#endif
#if TK_NUM_LP >8
    , TK_Threshold_Channel8_LP
#endif
#if TK_NUM_LP >9
    , TK_Threshold_Channel9_LP
#endif
#if TK_NUM_LP >10
    , TK_Threshold_Channel10_LP
#endif
#if TK_NUM_LP >11
    , TK_Threshold_Channel11_LP
#endif
#if TK_NUM_LP >12
    , TK_Threshold_Channel12_LP
#endif
#if TK_NUM_LP >13
    , TK_Threshold_Channel13_LP
#endif
#if TK_NUM_LP >14
    , TK_Threshold_Channel14_LP
#endif
#if TK_NUM_LP >15
    , TK_Threshold_Channel15_LP
#endif
#if TK_NUM_LP >16
    , TK_Threshold_Channel16_LP
#endif
#if TK_NUM_LP >17
    , TK_Threshold_Channel17_LP
#endif
#if TK_NUM_LP >18
    , TK_Threshold_Channel18_LP
#endif
#if TK_NUM_LP >19
    , TK_Threshold_Channel19_LP
#endif
#if TK_NUM_LP >20
    , TK_Threshold_Channel20_LP
#endif
#if TK_NUM_LP >21
    , TK_Threshold_Channel21_LP
#endif
#if TK_NUM_LP >22
    , TK_Threshold_Channel22_LP
#endif
#if TK_NUM_LP >23
    , TK_Threshold_Channel23_LP
#endif
#if TK_NUM_LP >24
    , TK_Threshold_Channel24_LP
#endif
#if TK_NUM_LP >25
    , TK_Threshold_Channel25_LP
#endif
#if TK_NUM_LP >26
    , TK_Threshold_Channel26_LP
#endif
#if TK_NUM_LP >27
    , TK_Threshold_Channel27_LP
#endif
#if TK_NUM_LP >28
    , TK_Threshold_Channel28_LP
#endif
#if TK_NUM_LP >29
    , TK_Threshold_Channel29_LP
#endif
#if TK_NUM_LP >30
    , TK_Threshold_Channel30_LP
#endif
};

const uint16_t Threshold_table_9_10[TK_NUM] = //Threshold * 9 / 10
{
#if TK_NUM >0
    TK_Threshold_Channel0 * 9 / 10
#endif
#if TK_NUM >1
    , TK_Threshold_Channel1 * 9 / 10
#endif
#if TK_NUM >2
    , TK_Threshold_Channel2 * 9 / 10
#endif
#if TK_NUM >3
    , TK_Threshold_Channel3 * 9 / 10
#endif
#if TK_NUM >4
    , TK_Threshold_Channel4 * 9 / 10
#endif
#if TK_NUM >5
    , TK_Threshold_Channel5 * 9 / 10
#endif
#if TK_NUM >6
    , TK_Threshold_Channel6 * 9 / 10
#endif
#if TK_NUM >7
    , TK_Threshold_Channel7 * 9 / 10
#endif
#if TK_NUM >8
    , TK_Threshold_Channel8 * 9 / 10
#endif
#if TK_NUM >9
    , TK_Threshold_Channel9 * 9 / 10
#endif
#if TK_NUM >10
    , TK_Threshold_Channel10 * 9 / 10
#endif
#if TK_NUM >11
    , TK_Threshold_Channel11 * 9 / 10
#endif
#if TK_NUM >12
    , TK_Threshold_Channel12 * 9 / 10
#endif
#if TK_NUM >13
    , TK_Threshold_Channel13 * 9 / 10
#endif
#if TK_NUM >14
    , TK_Threshold_Channel14 * 9 / 10
#endif
#if TK_NUM >15
    , TK_Threshold_Channel15 * 9 / 10
#endif
#if TK_NUM >16
    , TK_Threshold_Channel16 * 9 / 10
#endif
#if TK_NUM >17
    , TK_Threshold_Channel17 * 9 / 10
#endif
#if TK_NUM >18
    , TK_Threshold_Channel18 * 9 / 10
#endif
#if TK_NUM >19
    , TK_Threshold_Channel19 * 9 / 10
#endif
#if TK_NUM >20
    , TK_Threshold_Channel20 * 9 / 10
#endif
#if TK_NUM >21
    , TK_Threshold_Channel21 * 9 / 10
#endif
#if TK_NUM >22
    , TK_Threshold_Channel22 * 9 / 10
#endif
#if TK_NUM >23
    , TK_Threshold_Channel23 * 9 / 10
#endif
#if TK_NUM >24
    , TK_Threshold_Channel24 * 9 / 10
#endif
#if TK_NUM >25
    , TK_Threshold_Channel25 * 9 / 10
#endif
#if TK_NUM >26
    , TK_Threshold_Channel26 * 9 / 10
#endif
#if TK_NUM >27
    , TK_Threshold_Channel27 * 9 / 10
#endif
#if TK_NUM >28
    , TK_Threshold_Channel28 * 9 / 10
#endif
#if TK_NUM >29
    , TK_Threshold_Channel29 * 9 / 10
#endif
#if TK_NUM >30
    , TK_Threshold_Channel30 * 9 / 10
#endif
};

TKValueStru TK_Value_Arr[TK_NUM];
TKValueStru curr_tk_value;

uint8_t TK_chnum = TK_NUM;
const uint8_t DF_TK_Singlepress = TK_Singlepress;
const uint32_t DF_TK_reg_CON0 = TK_reg_CON0;
const uint32_t DF_TK_reg_CON0_bk1 = TK_reg_CON0_bk1;

#if Jitter_Function == ON
    uint8_t   TK_Jitter_tolerance[TK_NUM];
#endif
uint8_t   TK_value_get;         //Temp value flag after scan complete
uint8_t   Lock_averageconter;   //lock average flag
uint8_t   Lock_averageconter2;
uint32_t  TKS_CON0_ram;
uint8_t   Tkscan_numth;         //current processing TK channel
uint8_t   Tkscan_sampcounter;   //sampling count
uint8_t   Timer_counter;        //TK run timeout count
uint8_t   TK_press_counter;     //effective count of press
uint8_t   TK_release_counter;   //effective count of release
uint16_t  TK_Base_percounter;   //baseline update count
uint16_t  Opr_state;            //state machine of TK
uint16_t  TK_value;             //Temp value after scan
uint16_t  TK_jitter_Value;      //maximum and minimum differences
uint16_t  TK_pressing_value;    //maximum key value
uint32_t  TK_state;             //the key state
uint32_t  TK_state_single;      //maximum key state
uint32_t  TK_state_bk;          //for backup
/*     Opr_state
Bit15  Scan Enable bit   1 on 0 off
Bit14  Tempdata is full  1 full 0 receive
Bit13  Jillter sample enable bit  1 Enable     0  Disable
Bit12  Once scan complete bit     1 complete   0  busy
Bit11  Slider bit    1 Slider was be touch 0 not be touch
Bit10  Wheel  bit    1 Wheel  was be touch 0 not be touch
Bit9   Matrix Row bit     1   was be touch 0 not be touch
Bit8   Matrix Column bit  1   was be touch 0 not be touch
Bit7   Mode bit  0  Mode default  1  Mode2
Bit6   Mode switch start switching  if 1 else 0
Bit5   Powersave flag setting if 1 else 0
Bit4
Bit3
Bit2
Bit1
Bit0
*/

uint8_t BaseLineInitFlag;
uint8_t BaseLineInitCount;
uint8_t BaseLineInitChannelNum;
uint8_t BaseLineInitStart;

typedef struct
{
    int32_t input[3];
    int32_t output[3];
} tk_arr_t;

tk_arr_t tk_arr[TK_NUM];

#define FILTER_GAIN_INT (7)             /* (FILTER_GAIN * 256) */
#define FILTER_B0_INT   (256)           /* (FILTER_B0 * 256) */
#define FILTER_B1_INT   (512)           /* (FILTER_B1 * 256) */
#define FILTER_B2_INT   (256)           /* (FILTER_B2 * 256) */
#define FILTER_A1_INT   (-378)          /* (FILTER_A1 * 256) */
#define FILTER_A2_INT   (150)           /* (FILTER_A2 * 256) */

/**
  * @brief  low pass filter
  * @retval The filtered value
  */
uint16_t tk_filter_value(uint16_t data, tk_arr_t *ptr)
{
    ptr->input[2]  = (int32_t)(data * FILTER_GAIN_INT);
    ptr->output[2] = (FILTER_B0_INT * ptr->input[2] + FILTER_B1_INT * ptr->input[1] + FILTER_B2_INT * ptr->input[0] - FILTER_A1_INT * (ptr->output[1]) - FILTER_A2_INT * (ptr->output[0]));
    ptr->input[0]  = ptr->input[1];
    ptr->input[1]  = ptr->input[2];
    ptr->output[2] = (ptr->output[2] >> 8);
    ptr->output[0] = ptr->output[1];
    ptr->output[1] = ptr->output[2];

    return (uint16_t)(ptr->output[2] >> 8);
}

//#define FILTER_GAIN   (0.027859766117136031)
//#define FILTER_B0 (1.0)
//#define FILTER_B1 (2.0)
//#define FILTER_B2 (1.0)
//#define FILTER_A1 (-1.4754804435926461)
//#define FILTER_A2 (0.58691950806119031)

//uint16_t tk_filter_value(uint16_t data, tk_arr_t *ptr)
//{
//  uint16_t aaa;

//  ptr->input[2] = data * FILTER_GAIN;
//  ptr->output[2] = FILTER_B0 * ptr->input[2] + FILTER_B1 * ptr->input[1] + FILTER_B2 * ptr->input[0] - FILTER_A1 * ptr->output[1] - FILTER_A2 * ptr->output[0];

//  ptr->input[0] = ptr->input[1];
//  ptr->input[1] = ptr->input[2];
//  ptr->output[0] = ptr->output[1];
//  ptr->output[1] = ptr->output[2];
//  aaa = (uint16_t)ptr->output[2];

//  return aaa;
//}

/**
  * @brief  read/write the current channel data.
  * @param  idx: current channel num direct: read/write
  * @retval None
  */
void proc_curr_tk_value(uint8_t idx, uint8_t direct)
{
    uint8_t i = 0;
    char *ptr_d = (char *)&curr_tk_value;
    char *ptr_s = (char *)&TK_Value_Arr[idx];
    char *tmp = ptr_d;

    if (direct == 1)    //0:   1:д
    {
        ptr_d = ptr_s;
        ptr_s = tmp;
    }

    for (; i < sizeof(TKValueStru); i++)
    {
        *ptr_d++ = *ptr_s++;
    }

    //memcpy(ptr_d, ptr_s, sizeof(TKValueStru));
}

/**
  * @brief  Initializate TK moudle.
  * @retval None
  */
void TK_Init(void)
{
    TKValueStru *ptr;
#if (Jitter_Function == ON)||((TK_Lowpowermode == ON)&&(TK_LP_dataprocess_mode == Poll))
    uint8_t i = 0;
#endif

    Tkscan_numth        = 0;
    Tkscan_sampcounter  = 0;
    Opr_state           = 0x8000;//Enable scan
    TK_state            = 0;
    TK_Base_percounter  = 0;
    TK_value_get        = 0;
    Timer_10ms          = 0;
    Lock_averageconter  = 0;
    Timer_counter = 0;
#if TK_Lowpowermode == ON
    TK_Sleep_cnt = 0;
    g_wakeup_flag = 1;
    TK_mode1_nopresstimer = 0;
#if TK_LP_dataprocess_mode == Merge
    TK_md2average_backup = 0;
    sleep_first_data = 0;
    sleep_jitter_data = 0;
    lp_base_err_cnt = 0;
#endif
#if TK_LP_dataprocess_mode == Poll

    for (i = 0; i < TK_NUM_LP; i++)
    {
        TK_md2average_backup[i] = 0;
        sleep_first_data[i] = 0;
        sleep_jitter_data[i] = 0;
        lp_base_err_cnt[i] = 0;
    }

#endif
    Opr_state |= 0x0020;
#endif

    for (ptr = TK_Value_Arr; ptr < TK_Value_Arr + TK_NUM; ptr++) //Clear all
    {
        memset(ptr, 0, sizeof(TKValueStru));
#if Jitter_Function == ON
        TK_Jitter_tolerance[i] = 0;
        i++;
#endif
    }

    BaseLineInitFlag = 0;
    BaseLineInitCount = 0;
    BaseLineInitStart = 0;

    /* Enable the TK clock */
    ald_cmu_tks_clock_select(CMU_TKS_SEL_HRC);
    ald_cmu_perh_clock_config(CMU_PERH_TKS, ENABLE);

    TKS->CHEN = TK_Channel_Sel;
    TKS->CON0 = TK_reg_CON0;        //24Ƶ  1/2ռձ  ΪŴϵԳŵֵ
    TKS->CON1 = TK_reg_CON1;        //CpCx  Cxŵ256ʱ  2.5V
    TKS->GAIN = TK_Amplifi_setting;
    TKS->SFJTR = TK_reg_SFJTR;      //΢Ƶ
//    TKS->IE = 0x10;                 //ʹж
    TKS->IFC = 0x1F;                //жϱ־
#if TK_Guardsensor_output == ON
    TKS->CON0 |= 0x00002000;
#endif
#if Auto_Jitter_hardware == ON
    TKS->SFJTR |= 0x01000000;
#endif
}

/**
  * @brief  TK data process.
  * @retval None
  */
void Tk_service(void)
{
    uint8_t i, j;
    uint8_t Lock_average;
    uint8_t Mucheck;
    uint16_t Jitter = 0;
    uint16_t sum;
    uint16_t curr_Threshold;
    uint16_t curr_Threshold_9_10;
    uint16_t f_tmp;
    uint32_t pow_2;

    if (Opr_state & 0x4000)                     // Data was full process it
    {
#if Max_Minvalueoff_filter == ON   // Update the origin value  cut off the max and min value                                                                                   

        for (i = 0; i < TK_NUM; i++)
        {
            proc_curr_tk_value(i, 0);
            sum = curr_tk_value.tk_value_max + curr_tk_value.tk_value_min;
            curr_tk_value.tk_value_origin -= sum;
            Jitter += curr_tk_value.tk_value_max - curr_tk_value.tk_value_min;
            proc_curr_tk_value(i, 1);
        }

        TK_jitter_Value = Jitter;               // Refresh  the jitter value

        if (Jitter > Jitter_level1_Threshold)
        {
            Lock_averageconter = 68;
        }

#endif
//      Jitter = DataJitter();
//      TK_jitter_Value = Jitter;                     // Refresh  the jitter value
//      Software_jitterprocess(Jitter,Jitter_level1_Threshold,Jitter_level2_Threshold);
        TK_Base_percounter++;                   // Every come every ++
        BaseLineInitChannelNum = 0;

        for (i = 0; i < TK_NUM; i++)
        {
            pow_2 = pow_ulong(i);
            curr_Threshold = Threshold_table[i];
            curr_Threshold_9_10 = Threshold_table_9_10[i];

            proc_curr_tk_value(i, 0);

#if  TK_UARToutput_function == ON           // Update the UART data                                           
            UploadSampByte[2 * i]     = (uint8_t)(curr_tk_value.tk_value_origin >> 8);
            UploadSampByte[(2 * i) + 1] = (uint8_t)(curr_tk_value.tk_value_origin);
            UploadRawByte[2 * i]      = (uint8_t)(curr_tk_value.tk_value_filter >> 8);
            UploadRawByte[(2 * i) + 1]  = (uint8_t)(curr_tk_value.tk_value_filter);
            UploadBaseByte[2 * i]     = (uint8_t)(curr_tk_value.tk_value_average >> 8);
            UploadBaseByte[(2 * i) + 1] = (uint8_t)(curr_tk_value.tk_value_average);
#endif

            if (BaseLineInitFlag)
            {
                f_tmp = DataFilter(curr_tk_value.tk_value_origin, curr_tk_value.tk_value_filter);   // Origin data   Update value data

                curr_tk_value.tk_value_filter = (curr_tk_value.tk_value_filter + f_tmp) >> 1;
            }
            else if (TK_jitter_Value < TK_Threshold_Channel0 * TK_chnum)
            {
                if (BaseLineInitStart == 0)
                {
                    if (curr_tk_value.tk_value_average)
                    {
                        curr_tk_value.tk_value_filter = DataFilter(curr_tk_value.tk_value_origin, curr_tk_value.tk_value_filter);
                        curr_tk_value.tk_value_average = DataFilter(curr_tk_value.tk_value_average, curr_tk_value.tk_value_filter);
                    }
                    else
                    {
                        curr_tk_value.tk_value_filter  = curr_tk_value.tk_value_origin;
                        curr_tk_value.tk_value_average = curr_tk_value.tk_value_origin;
                    }

                    BaseLineInitChannelNum++;
                    curr_tk_value.tk_value_origin = 0;
                    proc_curr_tk_value(i, 1);
                    continue;
                }
                else
                {
                    for (j = 0; j < TK_chnum; j++)
                    {
                        TK_Value_Arr[j].tk_value_origin = 0;
                    }

                    break;
                }
            }
            else
            {
                for (j = 0; j < TK_chnum; j++)
                {
                    TK_Value_Arr[j].tk_value_origin = 0;
                }

                break;
            }

            if (curr_tk_value.tk_value_origin > (curr_tk_value.tk_value_average + curr_Threshold))
            {
                Lock_average = 1;                                // This time not update average
            }
            else
            {
                Lock_average = 0;

#if Jitter_Function == ON

                if (curr_tk_value.tk_press_table && (curr_tk_value.tk_press_table < TK_Debounce_press))      // No key press  but at press conter state  (TK_state &((ulong)1<<i))==0
                {
                    TK_Jitter_tolerance[i]++;

                    if (TK_Jitter_tolerance[i] > Jitter_tolerance)
                    {
                        curr_tk_value.tk_press_table = 0;                                               // Clear press counter
                        TK_Jitter_tolerance[i] = 0;
                    }
                }
                else
                {
                    TK_Jitter_tolerance[i] = 0;
                }

#else

                if ((curr_tk_value.tk_press_table < TK_Debounce_press) || (TK_jitter_Value > Jitter_level2_Threshold)) // No key press  but at press conter state  (TK_state &((ulong)1<<i))==0
                {
                    curr_tk_value.tk_press_table = 0;                       // Clear press counter
                }

#endif
            }

            /********************************************** Check Trigger *****************************************/
            Mucheck = 1;
#if  TK_Mult_inhibition > 0

            if (Mult_inhibition((curr_tk_value.tk_value_filter - curr_tk_value.tk_value_average), TK_Mult_inhibition))
            {
                Mucheck = 1;
            }
            else
            {
                Mucheck = 0;
                Lock_average = 0;

                if (TK_state & (pow_2))
                {
                    curr_tk_value.tk_release_table = TK_Debounce_release;
                    TK_state &= ~pow_2;
                    Customer_Keystatejustrelease();

                    if (curr_tk_value.tk_timeout_counter != 0)
                    {
                        curr_tk_value.tk_timeout_counter = 0;
                    }

                    curr_tk_value.tk_D_value = 0;
                }
            }

#endif

            if ((curr_tk_value.tk_value_filter > (curr_tk_value.tk_value_average + curr_Threshold)) && Mucheck)
            {
                curr_tk_value.tk_press_table++;
                curr_tk_value.tk_release_table = 0;
#if TK_Lowpowermode == ON

                if (g_wakeup_flag == 2)
                {
                    g_wakeup_flag = 1;    //߽׶
                    TKS->CON0 |= 0x00000002;                            // ʹܴʹģ飬TKGO = 1ɨ
                }

#endif

                if (curr_tk_value.tk_press_table > TK_Debounce_press)
                {
                    if (TK_jitter_Value < Jitter_level2_Threshold)
                    {
                        curr_tk_value.tk_press_table = TK_Debounce_press;
                        TK_state |= pow_2;                                              // Set trigger process
                        Customer_Keystatejustpress();

                        if (curr_tk_value.tk_timeout_counter == 0)
                        {
                            curr_tk_value.tk_timeout_counter = 1;
                        }

#if (TK_Singlepress == ON)||(TK_Mult_inhibition > 0)                                        // Save the Dlt value
                        curr_tk_value.tk_D_value = curr_tk_value.tk_value_filter - curr_tk_value.tk_value_average ; // Save the Dlt value
#endif
                    }
                    else
                    {
                        curr_tk_value.tk_press_table = 0;                                         // Clear
                    }
                }
            }
            else
            {
                curr_tk_value.tk_press_table = 0;             // Clear press counter
#if Jitter_Function == ON
                TK_Jitter_tolerance[i] = 0;
#endif

                if (TK_state & pow_2)                       // Already press prepare to release check
                {
                    if (curr_tk_value.tk_value_filter < (curr_tk_value.tk_value_average + curr_Threshold_9_10))
                    {
                        curr_tk_value.tk_release_table++;

                        if (curr_tk_value.tk_release_table > TK_Debounce_release)    // Release check
                        {
                            curr_tk_value.tk_release_table = TK_Debounce_release;
                            TK_state &= ~pow_2;//~((ulong)1<<i);                    // Clear this trigger bit process
                            TK_Base_percounter = 0;
                            Customer_Keystatejustrelease();

                            if (curr_tk_value.tk_timeout_counter != 0)
                            {
                                curr_tk_value.tk_timeout_counter = 0;
                            }       // Close timer counter

#if (TK_Singlepress == ON)||(TK_Mult_inhibition > 0)                                   // Save the Dlt value
                            curr_tk_value.tk_D_value = 0;      // Save the Dlt value
#endif
                        }
                    }
                    else
                    {
                        curr_tk_value.tk_release_table = 0;                                           // Clear the release counter
                    }
                }
                else if ((Lock_average == 0) && (TK_Base_percounter > TK_BaseSamples_perscan) && (Lock_averageconter == 0))
                {
                    //Update averagedata  ;
                    curr_tk_value.tk_value_average = DataFilter(curr_tk_value.tk_value_filter, curr_tk_value.tk_value_average);
                }
            }

            /********************************************** Check Trigger *****************************************/
            curr_tk_value.tk_value_origin = 0;                                     // Clear the origin data

            proc_curr_tk_value(i, 1);
        }

        if (BaseLineInitChannelNum >= TK_chnum)
        {
            BaseLineInitStart = 1;
        }

        if (TK_Base_percounter > (TK_BaseSamples_perscan + 0))
        {
            TK_Base_percounter = 0;
        } // For next every  TK_BaseSamples_perscan  sample update

        Opr_state &= ~0x4000;                             // Release this state
        //Single key press check
#if  TK_Singlepress == ON

        if (TK_state)                                                         // Any key pressed
        {
            Singlekeyprocess();                                                  // Get Single key press state
        }
        else
        {
            TK_state_single = 0;
        }

#endif

#if TK_Lowpowermode == ON

        if (TK_state)
        {
            TK_mode1_nopresstimer = 0;
        }

        if (g_wakeup_flag == 2)
        {
            g_wakeup_flag = 0;//߽׶
        }

#endif

        Opr_state |= 0x8000;                              // Enable the scan enable bit
    }
}

/**
  * @brief  Check the time flag.
  * @retval None
  */
void Timer_check(void)
{
    uint8_t i;

    if (Timer_10ms > Timercounter_10ms) //125 *80 10ms
    {
        Timer_10ms = 0;

        if (BaseLineInitStart == 1)
        {
            BaseLineInitStart = 0;
            BaseLineInitCount++;

            if (BaseLineInitCount >= 10)
            {
                BaseLineInitFlag = 1;//߳ʼ
            }
        }

#if TK_Lowpowermode == ON
        TK_mode1_nopresstimer++;       // Check switch to mode2 time

        if (TK_mode1_nopresstimer > TK_Mode0_nokeytoswitch_time)
        {
            TK_mode1_nopresstimer = TK_Mode0_nokeytoswitch_time;
        }

#endif

#if TK_UARToutput_function == ON

        if (Tx_timer)
        {
            Tx_timer++;

            if (Tx_timer > 100)
            {
                Tx_timer = 0;
                g_tp = 0;
                Uart_ready = 1;
            }       //Tx send 1s timeout send Reset
        }

        if (Rx_timer)
        {
            Rx_timer++;

            if (Rx_timer > 100)
            {
#if TK_UART_TYPE == TKM_UART
                ald_uart_recv_by_it(&h_uart_tk, &g_com, 1);
#endif
#if TK_UART_TYPE == TKM_USART
                ald_usart_recv_by_it(&h_usart0_tk, &g_com, 1);
#endif
#if TK_UART_TYPE == TKM_LPUART
                ald_lpuart_recv_frame_by_it(&h_lpuart_tk, &g_com, 1, 40);
#endif
                Uart_ready = 0;
                Rx_timer = 1;
            }
        }

#endif
        Timer_counter++;

        if (Timer_counter > 5) //50ms time out re start check TK scan
        {
            Timer_counter = 0;              // Measure time

            if (Opr_state & 0x8000)         // Scan Enable
            {
                TKS->CON0 = TK_reg_CON0;        //24Ƶ  1/2ռձ  ΪŴϵԳŵֵ
                TKS->CON1 = TK_reg_CON1;        //CpCx  Cxŵ256ʱ  2.5V
                TKS->CHEN = TK_Channel_Sel;
                TKS->GAIN = TK_Amplifi_setting; //Ŵϵ
#if TK_Guardsensor_output == ON
                TKS->CON0 |= 0x00002000;
#endif
#if Auto_Jitter_hardware == ON
                TKS->SFJTR |= 0x01000000;
#endif
                TK_value_get = 0;
//              Config_TKIO(Channel_table[Tkscan_numth]);
                TKS->CON0 |= 0x02;
            }
        }

        if (Lock_averageconter > 2)
        {
            Lock_averageconter--;

            if (Lock_averageconter < 5)
            {
                Lock_averageconter = 0;
            }
        }

        if (Lock_averageconter2 > 2)
        {
            Lock_averageconter2--;

            if (Lock_averageconter2 < 5)
            {
                Lock_averageconter2 = 0;
            }
        }

        for (i = 0; i < TK_NUM; i++)                // Press timeout check
        {
            proc_curr_tk_value(i, 0);

            if (curr_tk_value.tk_timeout_counter == 0)                       // This num not press ignore
            {
                continue;
            }
            else
            {
                curr_tk_value.tk_timeout_counter = curr_tk_value.tk_timeout_counter + 1;

                if (curr_tk_value.tk_timeout_counter >= TK_Press_timeout)        // Timeout force average and cancer the press state
                {
                    curr_tk_value.tk_timeout_counter = 0;
                    Force_average(i);                 // Do force average
                }
            }

            proc_curr_tk_value(i, 1);
        }
    } //End of if(Timer_10ms >Timercounter_10ms) //125 *80 10ms
}

/**
  * @brief  Get the TK channel data.
  * @retval None
  */
void Update_TKdata(void)
{
    uint8_t i;

    if (TK_value_get == 1)
    {
        for (i = 0; i < TK_NUM; i++)
        {
            proc_curr_tk_value(i, 0);

            TK_value = (uint16_t)TKS->CHRES[Channel_table[i]];

			TK_value = tk_filter_value(TK_value, &tk_arr[i]);				
			
            curr_tk_value.tk_value_origin += TK_value;

#if  Max_Minvalueoff_filter == ON

            if (Tkscan_sampcounter == 0)                //First value
            {
                curr_tk_value.tk_value_max = TK_value;
                curr_tk_value.tk_value_min = TK_value;
            }
            else if (TK_value > curr_tk_value.tk_value_max)
            {
                curr_tk_value.tk_value_max = TK_value;
            }
            else if (TK_value < curr_tk_value.tk_value_min)
            {
                curr_tk_value.tk_value_min = TK_value;
            }

#endif
            proc_curr_tk_value(i, 1);
        }

        Tkscan_sampcounter++;

        if (Tkscan_sampcounter >= TK_Samples_perscan)
        {
#if TK_Lowpowermode == ON

            if (TK_mode1_nopresstimer > TK_Mode0_nokeytoswitch_time)
            {
                g_wakeup_flag = 2;  //prapare to sleep by step2
                TK_mode1_nopresstimer = 0;
            }

#endif
            Tkscan_sampcounter = 0;
            Opr_state |= 0x4000;                           // Set data is full let Tk_service process
            //if(Opr_state &0x0010){TKIE =0;}                 // if at get baseline state   Clear the TKIE
        }

        if (Opr_state & 0x4000)
        {
            Opr_state &= ~0x8000; // Clear the scan enable bit if data is full  wait data process  also have one data can be scan
        }

        TK_value_get = 2;
    }
}
