/**
  *********************************************************************************
  *
  * @file    tk_handle.c
  * @brief   TK Data Process
  *
  * @version V1.0
  * @date    7 Jul 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          7 Jul 2023      AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */
#include "main.h"

uint32_t pow_ulong(uint8_t i)
{
    return ((uint32_t)1 << i);
}

ALIGN(RT_ALIGN_SIZE)
const uint8_t Channel_table[TK_NUM] =     // Channel table for use as tk channel
{
#if TK_NUM >0
    TK_Channel0
#endif
#if TK_NUM >1
    , TK_Channel1
#endif
#if TK_NUM >2
    , TK_Channel2
#endif
#if TK_NUM >3
    , TK_Channel3
#endif
#if TK_NUM >4
    , TK_Channel4
#endif
#if TK_NUM >5
    , TK_Channel5
#endif
#if TK_NUM >6
    , TK_Channel6
#endif
#if TK_NUM >7
    , TK_Channel7
#endif
#if TK_NUM >8
    , TK_Channel8
#endif
#if TK_NUM >9
    , TK_Channel9
#endif
#if TK_NUM >10
    , TK_Channel10
#endif
#if TK_NUM >11
    , TK_Channel11
#endif
#if TK_NUM >12
    , TK_Channel12
#endif
#if TK_NUM >13
    , TK_Channel13
#endif
#if TK_NUM >14
    , TK_Channel14
#endif
#if TK_NUM >15
    , TK_Channel15
#endif
#if TK_NUM >16
    , TK_Channel16
#endif
#if TK_NUM >17
    , TK_Channel17
#endif
#if TK_NUM >18
    , TK_Channel18
#endif
#if TK_NUM >19
    , TK_Channel19
#endif
#if TK_NUM >20
    , TK_Channel20
#endif
#if TK_NUM >21
    , TK_Channel21
#endif
#if TK_NUM >22
    , TK_Channel22
#endif
#if TK_NUM >23
    , TK_Channel23
#endif
#if TK_NUM >24
    , TK_Channel24
#endif
#if TK_NUM >25
    , TK_Channel25
#endif
#if TK_NUM >26
    , TK_Channel26
#endif
#if TK_NUM >27
    , TK_Channel27
#endif
#if TK_NUM >28
    , TK_Channel28
#endif
#if TK_NUM >29
    , TK_Channel29
#endif
#if TK_NUM >30
    , TK_Channel30
#endif
};

ALIGN(RT_ALIGN_SIZE)
const uint16_t Threshold_table[TK_NUM] =    // Threshold table for tk channel
{
#if TK_NUM >0
    TK_Threshold_Channel0
#endif
#if TK_NUM >1
    , TK_Threshold_Channel1
#endif
#if TK_NUM >2
    , TK_Threshold_Channel2
#endif
#if TK_NUM >3
    , TK_Threshold_Channel3
#endif
#if TK_NUM >4
    , TK_Threshold_Channel4
#endif
#if TK_NUM >5
    , TK_Threshold_Channel5
#endif
#if TK_NUM >6
    , TK_Threshold_Channel6
#endif
#if TK_NUM >7
    , TK_Threshold_Channel7
#endif
#if TK_NUM >8
    , TK_Threshold_Channel8
#endif
#if TK_NUM >9
    , TK_Threshold_Channel9
#endif
#if TK_NUM >10
    , TK_Threshold_Channel10
#endif
#if TK_NUM >11
    , TK_Threshold_Channel11
#endif
#if TK_NUM >12
    , TK_Threshold_Channel12
#endif
#if TK_NUM >13
    , TK_Threshold_Channel13
#endif
#if TK_NUM >14
    , TK_Threshold_Channel14
#endif
#if TK_NUM >15
    , TK_Threshold_Channel15
#endif
#if TK_NUM >16
    , TK_Threshold_Channel16
#endif
#if TK_NUM >17
    , TK_Threshold_Channel17
#endif
#if TK_NUM >18
    , TK_Threshold_Channel18
#endif
#if TK_NUM >19
    , TK_Threshold_Channel19
#endif
#if TK_NUM >20
    , TK_Threshold_Channel20
#endif
#if TK_NUM >21
    , TK_Threshold_Channel21
#endif
#if TK_NUM >22
    , TK_Threshold_Channel22
#endif
#if TK_NUM >23
    , TK_Threshold_Channel23
#endif
#if TK_NUM >24
    , TK_Threshold_Channel24
#endif
#if TK_NUM >25
    , TK_Threshold_Channel25
#endif
#if TK_NUM >26
    , TK_Threshold_Channel26
#endif
#if TK_NUM >27
    , TK_Threshold_Channel27
#endif
#if TK_NUM >28
    , TK_Threshold_Channel28
#endif
#if TK_NUM >29
    , TK_Threshold_Channel29
#endif
#if TK_NUM >30
    , TK_Threshold_Channel30
#endif
};

ALIGN(RT_ALIGN_SIZE)
const uint16_t Threshold_table_9_10[TK_NUM] = //Threshold * 9 / 10
{
#if TK_NUM >0
    TK_Threshold_Channel0 * 9 / 10
#endif
#if TK_NUM >1
    , TK_Threshold_Channel1 * 9 / 10
#endif
#if TK_NUM >2
    , TK_Threshold_Channel2 * 9 / 10
#endif
#if TK_NUM >3
    , TK_Threshold_Channel3 * 9 / 10
#endif
#if TK_NUM >4
    , TK_Threshold_Channel4 * 9 / 10
#endif
#if TK_NUM >5
    , TK_Threshold_Channel5 * 9 / 10
#endif
#if TK_NUM >6
    , TK_Threshold_Channel6 * 9 / 10
#endif
#if TK_NUM >7
    , TK_Threshold_Channel7 * 9 / 10
#endif
#if TK_NUM >8
    , TK_Threshold_Channel8 * 9 / 10
#endif
#if TK_NUM >9
    , TK_Threshold_Channel9 * 9 / 10
#endif
#if TK_NUM >10
    , TK_Threshold_Channel10 * 9 / 10
#endif
#if TK_NUM >11
    , TK_Threshold_Channel11 * 9 / 10
#endif
#if TK_NUM >12
    , TK_Threshold_Channel12 * 9 / 10
#endif
#if TK_NUM >13
    , TK_Threshold_Channel13 * 9 / 10
#endif
#if TK_NUM >14
    , TK_Threshold_Channel14 * 9 / 10
#endif
#if TK_NUM >15
    , TK_Threshold_Channel15 * 9 / 10
#endif
#if TK_NUM >16
    , TK_Threshold_Channel16 * 9 / 10
#endif
#if TK_NUM >17
    , TK_Threshold_Channel17 * 9 / 10
#endif
#if TK_NUM >18
    , TK_Threshold_Channel18 * 9 / 10
#endif
#if TK_NUM >19
    , TK_Threshold_Channel19 * 9 / 10
#endif
#if TK_NUM >20
    , TK_Threshold_Channel20 * 9 / 10
#endif
#if TK_NUM >21
    , TK_Threshold_Channel21 * 9 / 10
#endif
#if TK_NUM >22
    , TK_Threshold_Channel22 * 9 / 10
#endif
#if TK_NUM >23
    , TK_Threshold_Channel23 * 9 / 10
#endif
#if TK_NUM >24
    , TK_Threshold_Channel24 * 9 / 10
#endif
#if TK_NUM >25
    , TK_Threshold_Channel25 * 9 / 10
#endif
#if TK_NUM >26
    , TK_Threshold_Channel26 * 9 / 10
#endif
#if TK_NUM >27
    , TK_Threshold_Channel27 * 9 / 10
#endif
#if TK_NUM >28
    , TK_Threshold_Channel28 * 9 / 10
#endif
#if TK_NUM >29
    , TK_Threshold_Channel29 * 9 / 10
#endif
#if TK_NUM >30
    , TK_Threshold_Channel30 * 9 / 10
#endif
};

TKValueStru TK_Value_Arr[TK_NUM];
TKValueStru curr_tk_value;

uint8_t TK_chnum = TK_NUM;
const uint8_t DF_TK_Singlepress = 0;
const uint32_t DF_TK_reg_CON0 = TK_reg_CON0;
const uint32_t DF_TK_reg_CON0_bk1 = TK_reg_CON0_bk1;

uint8_t   TK_value_get;         //Temp value flag after scan complete
uint8_t   Lock_averageconter;   //lock average flag
uint8_t   Lock_averageconter2;
uint32_t  TKS_CON0_ram;
uint8_t   Tkscan_numth;         //current processing TK channel
uint8_t   Tkscan_sampcounter;   //sampling count
uint8_t   Timer_counter;        //TK run timeout count
uint8_t   TK_press_counter;     //effective count of press
uint8_t   TK_release_counter;   //effective count of release
uint16_t  TK_Base_percounter;   //baseline update count
uint16_t  Opr_state;            //state machine of TK
uint16_t  TK_value;             //Temp value after scan
uint16_t  TK_jitter_Value;      //maximum and minimum differences
uint16_t  TK_pressing_value;    //maximum key value
uint32_t  TK_state;             //the key state
uint32_t  TK_state_single;      //maximum key state
//uint32_t  TK_state_bk;          //for backup
/*     Opr_state
Bit15  Scan Enable bit   1 on 0 off
Bit14  Tempdata is full  1 full 0 receive
Bit13  Jillter sample enable bit  1 Enable     0  Disable
Bit12  Once scan complete bit     1 complete   0  busy
Bit11  Slider bit    1 Slider was be touch 0 not be touch
Bit10  Wheel  bit    1 Wheel  was be touch 0 not be touch
Bit9   Matrix Row bit     1   was be touch 0 not be touch
Bit8   Matrix Column bit  1   was be touch 0 not be touch
Bit7   Mode bit  0  Mode default  1  Mode2
Bit6   Mode switch start switching  if 1 else 0
Bit5   Powersave flag setting if 1 else 0
Bit4
Bit3
Bit2
Bit1
Bit0
*/
static rt_timer_t timer1 = RT_NULL;;
static rt_thread_t thread1 = RT_NULL;
static rt_thread_t thread2 = RT_NULL;
rt_sem_t nw_TK_value, nw_original_value;

/**
  * @brief  read/write the current channel data.
  * @param  idx: current channel num direct: read/write
  * @retval None
  */
void proc_curr_tk_value(uint8_t idx, uint8_t direct)
{
    uint8_t i = 0;
    char *ptr_d = (char *)&curr_tk_value;
    char *ptr_s = (char *)&TK_Value_Arr[idx];
    char *tmp = ptr_d;

    if (direct == 1)    //0:   1:д
    {
        ptr_d = ptr_s;
        ptr_s = tmp;
    }

    for (; i < sizeof(TKValueStru); i++)
    {
        *ptr_d++ = *ptr_s++;
    }

    //memcpy(ptr_d, ptr_s, sizeof(TKValueStru));
}

/**
  * @brief  Check the time flag.
  * @retval None
  */
static void Timer_check(void *parameter)
{
    Timer_counter++;

    if (Timer_counter > 5) //50ms time out re start check TK scan
    {
        Timer_counter = 0;              // Measure time

        if (Opr_state & 0x8000)         // Scan Enable
        {
            TKS->CON0 = TK_reg_CON0;        //24Ƶ  1/2ռձ  ΪŴϵԳŵֵ
            TKS->CON1 = TK_reg_CON1;        //CpCx  Cxŵ256ʱ  2.5V
            TKS->CHEN = TK_Channel_Sel;
            TKS->GAIN = 0x000FFFFF; //Ŵϵ
            TK_value_get = 0;
            TKS->CON0 |= 0x02;
        }
    }

    if (Lock_averageconter > 2)
    {
        Lock_averageconter--;

        if (Lock_averageconter < 5)
        {
            Lock_averageconter = 0;
        }
    }

    if (Lock_averageconter2 > 2)
    {
        Lock_averageconter2--;

        if (Lock_averageconter2 < 5)
        {
            Lock_averageconter2 = 0;
        }
    }
}

/**
  * @brief  Get the TK channel data.
  * @retval None
  */
static void Update_TKdata(void *parameter)
{
    uint8_t i;

    nw_TK_value = rt_sem_create("TK_value", 0, RT_IPC_FLAG_PRIO);

    while (1)
    {
        rt_sem_take(nw_TK_value, RT_WAITING_FOREVER);

        if (Opr_state & 0x8000)   //At scan enable state
        {
            if (TK_value_get == 1)
            {
                for (i = 0; i < TK_NUM; i++)
                {
                    proc_curr_tk_value(i, 0);

                    TK_value = (uint16_t)TKS->CHRES[Channel_table[i]];

                    curr_tk_value.tk_value_origin += TK_value;

                    if (Tkscan_sampcounter == 0)                //First value
                    {
                        curr_tk_value.tk_value_max = TK_value;
                        curr_tk_value.tk_value_min = TK_value;
                    }
                    else if (TK_value > curr_tk_value.tk_value_max)
                    {
                        curr_tk_value.tk_value_max = TK_value;
                    }
                    else if (TK_value < curr_tk_value.tk_value_min)
                    {
                        curr_tk_value.tk_value_min = TK_value;
                    }

                    proc_curr_tk_value(i, 1);
                }

                Tkscan_sampcounter++;

                if (Tkscan_sampcounter >= TK_Samples_perscan)
                {
                    Tkscan_sampcounter = 0;
                    Opr_state |= 0x4000;                           // Set data is full let Tk_service process
                    rt_sem_release(nw_original_value);
                    //if(Opr_state &0x0010){TKIE =0;}                 // if at get baseline state   Clear the TKIE
                }

                if (Opr_state & 0x4000)
                {
                    Opr_state &= ~0x8000; // Clear the scan enable bit if data is full  wait data process  also have one data can be scan
                }

                TKS->CON0 |= 0x00000002;                            // ʹܴʹģ飬TKGO = 1ɨ
                TK_value_get = 0;
            }
        }
    }
}

/**
  * @brief  TK data process.
  * @retval None
  */
static void Tk_service(void *parameter)
{
    uint8_t i;
    uint8_t Lock_average;
    uint8_t Mucheck;
    uint16_t Jitter;
    uint16_t sum;
    uint16_t curr_Threshold;
    uint16_t curr_Threshold_9_10;
    uint32_t pow_2;

    nw_original_value =  rt_sem_create("original_value", 0, RT_IPC_FLAG_PRIO);

    while (1)
    {
        rt_sem_take(nw_original_value, RT_WAITING_FOREVER);

        Jitter = 0;

        if (Opr_state & 0x4000)                     // Data was full process it
        {
            for (i = 0; i < TK_NUM; i++)
            {
                proc_curr_tk_value(i, 0);
                sum = curr_tk_value.tk_value_max + curr_tk_value.tk_value_min;
                curr_tk_value.tk_value_origin -= sum;
                Jitter += curr_tk_value.tk_value_max - curr_tk_value.tk_value_min;
                proc_curr_tk_value(i, 1);
            }

            TK_jitter_Value = Jitter;               // Refresh  the jitter value

            if (Jitter > Jitter_level1_Threshold)
            {
                Lock_averageconter = 68;
            }

            TK_Base_percounter++;                   // Every come every ++

            for (i = 0; i < TK_NUM; i++)
            {
                pow_2 = pow_ulong(i);
                curr_Threshold = Threshold_table[i];
                curr_Threshold_9_10 = Threshold_table_9_10[i];

                proc_curr_tk_value(i, 0);

                if (curr_tk_value.tk_value_average)     //if not 0
                {
                    curr_tk_value.tk_value_filter = DataFilter(curr_tk_value.tk_value_origin, curr_tk_value.tk_value_filter);   // Origin data   Update value data
                }
                else                          // if 0 do the get baseline process
                {
                    curr_tk_value.tk_value_filter  = curr_tk_value.tk_value_origin;
                    curr_tk_value.tk_value_average = curr_tk_value.tk_value_origin;
                }

                if (curr_tk_value.tk_value_origin > (curr_tk_value.tk_value_average + curr_Threshold))
                {
                    Lock_average = 1;                                // This time not update average
                }
                else
                {
                    Lock_average = 0;

                    if ((curr_tk_value.tk_press_table < TK_Debounce_press) || (TK_jitter_Value > Jitter_level2_Threshold)) // No key press  but at press conter state  (TK_state &((ulong)1<<i))==0
                    {
                        curr_tk_value.tk_press_table = 0;                       // Clear press counter
                    }
                }

                /********************************************** Check Trigger *****************************************/
                Mucheck = 1;

                if ((curr_tk_value.tk_value_filter > (curr_tk_value.tk_value_average + curr_Threshold)) && Mucheck)
                {
                    curr_tk_value.tk_press_table++;
                    curr_tk_value.tk_release_table = 0;

                    if (curr_tk_value.tk_press_table > TK_Debounce_press)
                    {
                        if (TK_jitter_Value < Jitter_level2_Threshold)
                        {
                            curr_tk_value.tk_press_table = TK_Debounce_press;
                            TK_state |= pow_2;                                              // Set trigger process
                            Customer_Keystatejustpress();

                            if (curr_tk_value.tk_timeout_counter == 0)
                            {
                                curr_tk_value.tk_timeout_counter = 1;
                            }
                        }
                        else
                        {
                            curr_tk_value.tk_press_table = 0;                                         // Clear
                        }
                    }
                }
                else
                {
                    curr_tk_value.tk_press_table = 0;             // Clear press counter

                    if (TK_state & pow_2)                       // Already press prepare to release check
                    {
                        if (curr_tk_value.tk_value_filter < (curr_tk_value.tk_value_average + curr_Threshold_9_10))
                        {
                            curr_tk_value.tk_release_table++;

                            if (curr_tk_value.tk_release_table > TK_Debounce_release)    // Release check
                            {
                                curr_tk_value.tk_release_table = TK_Debounce_release;
                                TK_state &= ~pow_2;//~((ulong)1<<i);                    // Clear this trigger bit process
                                Customer_Keystatejustrelease();

                                if (curr_tk_value.tk_timeout_counter != 0)
                                {
                                    curr_tk_value.tk_timeout_counter = 0;
                                }       // Close timer counter
                            }
                        }
                        else
                        {
                            curr_tk_value.tk_release_table = 0;                                           // Clear the release counter
                        }
                    }
                    else if ((Lock_average == 0) && (TK_Base_percounter > TK_BaseSamples_perscan) && (Lock_averageconter == 0))
                    {
                        //Update averagedata  ;
                        curr_tk_value.tk_value_average = DataFilter(curr_tk_value.tk_value_filter, curr_tk_value.tk_value_average);
                    }
                }

                /********************************************** Check Trigger *****************************************/
                curr_tk_value.tk_value_origin = 0;                                     // Clear the origin data

                proc_curr_tk_value(i, 1);
            }

            if (TK_Base_percounter > (TK_BaseSamples_perscan + 0))
            {
                TK_Base_percounter = 0;
            } // For next every  TK_BaseSamples_perscan  sample update

            Opr_state &= ~0x4000;                             // Release this state

            Opr_state |= 0x8000;                              // Enable the scan enable bit
        }
    }
}

/**
  * @brief  TK_sample
  * @retval None
  */
int TK_sample(void)
{
    timer1 = rt_timer_create("timer1", Timer_check, RT_NULL, 1, RT_TIMER_FLAG_PERIODIC);

    if (timer1 != RT_NULL)
        rt_timer_start(timer1);

    thread1 = rt_thread_create("thread1", Update_TKdata, RT_NULL, 512, 8, 5);

    if (thread1 != RT_NULL)
        rt_thread_startup(thread1);

    thread2 = rt_thread_create("thread2", Tk_service, RT_NULL, 512, 8, 5);

    if (thread2 != RT_NULL)
        rt_thread_startup(thread2);

    return 0;
}
