/**
  *********************************************************************************
  *
  * @file    tkm_config.h
  * @brief   Header file for TK DEMO
  *
  * @version V1.0
  * @date    2 Dec 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
    *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#ifndef   __TK_CONFIG_H__
#define   __TK_CONFIG_H__

#define  TK_NUM                         2                          // ذ1--32

#define  TK_Channel_Sel                 0x00000003                 // ÿһλӦҪʹõTKͨ

#define  TK_Channel0                    TK0        // TK0--TK11  ظ ͬ
#define  TK_Channel1                    TK1
#define  TK_Channel2                    TK9
#define  TK_Channel3                    TK20
#define  TK_Channel4                    TK5
#define  TK_Channel5                    TK8
#define  TK_Channel6                    TK6
#define  TK_Channel7                    TK7
#define  TK_Channel8                    TK8         // TK0--TK11  ظ ͬ
#define  TK_Channel9                    TK9
#define  TK_Channel10                   TK10
#define  TK_Channel11                   TK11
#define  TK_Channel12                   TK12
#define  TK_Channel13                   TK13
#define  TK_Channel14                   TK14
#define  TK_Channel15                   TK15
#define  TK_Channel16                   TK16        // TK0--TK11  ظ ͬ
#define  TK_Channel17                   TK17
#define  TK_Channel18                   TK18
#define  TK_Channel19                   TK19
#define  TK_Channel20                   TK20
#define  TK_Channel21                   TK21
#define  TK_Channel22                   TK22
#define  TK_Channel23                   TK23
#define  TK_Channel24                   TK24        // TK0--TK11  ظ ͬ
#define  TK_Channel25                   TK25
#define  TK_Channel26                   TK26
#define  TK_Channel27                   TK27
#define  TK_Channel28                   TK28
#define  TK_Channel29                   TK30
#define  TK_Channel30                   TK31

#define  TK_Threshold_Channel0          100        // Ӿ 30--3000  ָӰ Dltֵһ
#define  TK_Threshold_Channel1          100        //
#define  TK_Threshold_Channel2          100        //
#define  TK_Threshold_Channel3          100        //
#define  TK_Threshold_Channel4          100        //
#define  TK_Threshold_Channel5          100        //
#define  TK_Threshold_Channel6          100        //
#define  TK_Threshold_Channel7          100        //
#define  TK_Threshold_Channel8          100        // Ӿ 30--3000  ָӰ Dltֵһ
#define  TK_Threshold_Channel9          100        //
#define  TK_Threshold_Channel10         100        //
#define  TK_Threshold_Channel11         100        //
#define  TK_Threshold_Channel12         100        //
#define  TK_Threshold_Channel13         100        //
#define  TK_Threshold_Channel14         100        //
#define  TK_Threshold_Channel15         100        //
#define  TK_Threshold_Channel16         100        // Ӿ 30--3000  ָӰ Dltֵһ
#define  TK_Threshold_Channel17         100        //
#define  TK_Threshold_Channel18         100        //
#define  TK_Threshold_Channel19         100        //
#define  TK_Threshold_Channel20         100        //
#define  TK_Threshold_Channel21         100        //
#define  TK_Threshold_Channel22         100        //
#define  TK_Threshold_Channel23         100        //
#define  TK_Threshold_Channel24         100        // Ӿ 30--3000  ָӰ Dltֵһ
#define  TK_Threshold_Channel25         1000        //
#define  TK_Threshold_Channel26         1000        //
#define  TK_Threshold_Channel27         1000        //
#define  TK_Threshold_Channel28         1000        //
#define  TK_Threshold_Channel29         1000        //
#define  TK_Threshold_Channel30         1000        //

#define  TK_Samples_perscan             3                           /*ۼ趨1--16 16λ*/
#define  TK_BaseSamples_perscan         (1000/TK_NUM)              /*߸ 趨1--65535*/
#define  TK_Debounce_press              10                          /*µĴ趨*/
#define  TK_Debounce_release            5                           /*뿪Ĵ趨*/
#define  Jitter_level1_Threshold        (TK_Threshold_Channel0*1.5*TK_NUM)                                          /*When more than this  value use a specilize filter  base was locked    Type value  SUM(TK_Threshold_Channeln,n=0~TK_NUM-1)*0.3*/
#define  Jitter_level2_Threshold        (TK_Threshold_Channel0*3*TK_NUM)                        /*When more than this  value use a specilize filter  base was locked    Type value  SUM(TK_Threshold_Channeln,n=0~TK_NUM-1)*0.3*/

//TK_advance
#define  TK_reg_CON0                    0x00508519          // 2M
#define  TK_reg_CON0_bk1                0x00308519          // 4M
#define  TK_reg_CON0_bk2                0x00708519          // 1M
#define  TK_reg_CON1                    0x6038047B          // 2.3V
#define  TK_reg_SFJTR                   0//0x01000000       //0x00010505 //΢Ƶ 2M

#define  TK_reg_CON0_merge              0x00528508          // 2M
#define  TK_reg_CON0_poll               0x00528518          // 2M
#define  TK_reg_CON1_sleep              0x6038047B          // 2.3V

#define  TK0                            0                   // PA0
#define  TK1                            1                   // PA1
#define  TK2                            2                   // PA2
#define  TK3                            3                   // PA3
#define  TK4                            4                   // PA4
#define  TK5                            5                   // PA5
#define  TK6                            6                   // PA6
#define  TK7                            7                   // PA7  
#define  TK8                            8                   // PB0
#define  TK9                            9                   // PB1
#define  TK10                           10                  // PB2
#define  TK11                           11                  // PB10
#define  TK12                           12                  // PB11
#define  TK13                           13                  // PB12
#define  TK14                           14                  // PB13
#define  TK15                           15                  // PB14
#define  TK16                           16                  // PB15
#define  TK17                           17                  // PA8
#define  TK18                           18                  // PA9
#define  TK19                           19                  // PA10
#define  TK20                           20                  // PA11
#define  TK21                           21                  // PA12
#define  TK22                           22                  // PA15
#define  TK23                           23                  // PB3
#define  TK24                           24                  // PB4
#define  TK25                           25                  // PB5
#define  TK26                           26                  // PB6
#define  TK27                           27                  // PB7
#define  TK28                           28                  // PB9
#define  TK30                           30                  // PC3
#define  TK31                           31                  // PC4

#define  ON                             1
#define  OFF                            0
#define  LED_On                         1
#define  LED_Off                        0
#define  Toggle                         1
#define  Indicate                       0
#define  Merge                          1
#define  Poll                           0
#define  TKM_UART                       1
#define  TKM_USART                      2
#define  TKM_LPUART                     3
/************************************************************************************************************************************/

#endif
