/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include <rtthread.h>
#include "main.h"

#define THREAD_STACK_SIZE   384
#define THREAD_PRIORITY     8

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

static struct rt_thread *tid1 = RT_NULL;
static struct rt_thread *tid2 = RT_NULL;
static struct rt_thread *tid3 = RT_NULL;
static struct rt_messagequeue *mq;

static void thread1_entry(void *parameter)
{
    char buf[128];

    while (1)
    {
        rt_memset(&buf[0], 0, sizeof(buf));

        if (rt_mq_recv(mq, &buf[0], sizeof(buf), RT_WAITING_FOREVER) == RT_EOK)
            rt_kprintf("thread1: recv msg from message queue, the content:%s\n", buf);

        rt_thread_delay(10);
    }
}

static void thread2_entry(void *parameter)
{
    int i, result;
    char buf[] = "this is message No.x";

    while (1)
    {
        for (i = 0; i < 10; i++)
        {
            buf[sizeof(buf) - 2] = '0' + i;
            rt_kprintf("thread2: send message - %s\n", buf);

            result = rt_mq_send(mq, &buf[0], sizeof(buf));

            if (result == -RT_EFULL)
            {
                rt_kprintf("message queue full, delay 1s\n");
                rt_thread_delay(100);
            }
        }

        rt_thread_delay(10);
    }
}

static void thread3_entry(void *parameter)
{
    char buf[] = "this is an urgent message!";

    while (1)
    {
        rt_kprintf("thread3: send an urgent message\n");
        rt_mq_urgent(mq, &buf[0], sizeof(buf));

        rt_thread_delay(25);
    }
}
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    mq = rt_mq_create("mqt", 32, 16, RT_IPC_FLAG_FIFO);

    tid1 = rt_thread_create("t1", thread1_entry, RT_NULL,
                            THREAD_STACK_SIZE, THREAD_PRIORITY, 5);

    if (tid1 != RT_NULL)
        rt_thread_startup(tid1);

    tid2 = rt_thread_create("t2", thread2_entry, RT_NULL,
                            THREAD_STACK_SIZE, THREAD_PRIORITY, 5);

    if (tid2 != RT_NULL)
        rt_thread_startup(tid2);

    tid3 = rt_thread_create("t3", thread3_entry, RT_NULL,
                            THREAD_STACK_SIZE, THREAD_PRIORITY, 5);

    if (tid3 != RT_NULL)
        rt_thread_startup(tid3);

    return 0;
}

/**
  * @}
  */
/**
  * @}
  */
