/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include <rtthread.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

static rt_timer_t timer1;
static rt_timer_t timer2;


static void timeout1(void *parameter)
{
    rt_kprintf("periodic timer is timeout\n");
}


static void timeout2(void *parameter)
{
    rt_kprintf("one shot timer is timeout\n");
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    timer1 = rt_timer_create("timer1", timeout1, RT_NULL, 800, RT_TIMER_FLAG_PERIODIC);

    if (timer1 != RT_NULL)
        rt_timer_start(timer1);

    timer2 = rt_timer_create("timer2", timeout2, RT_NULL, 500, RT_TIMER_FLAG_ONE_SHOT);

    if (timer2 != RT_NULL)
        rt_timer_start(timer2);

    return 0;
}

/**
  * @}
  */
/**
  * @}
  */
