/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#include <rtthread.h>
#include "main.h"

#define THREAD_STACK_SIZE   256
#define THREAD_PRIORITY     8

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
static rt_thread_t tid1 = RT_NULL;
static rt_thread_t tid2 = RT_NULL;
static rt_thread_t tid3 = RT_NULL;

static void thread0_entry(void *parameter)
{
    uint32_t count = 0;
    uint32_t no = (rt_uint32_t)parameter;

    while (1)
    {
        rt_kprintf("thread%d count: %d\n", no, ++count);
        rt_thread_delay(3);
    }
}

static void thread1_entry(void *parameter)
{
    uint32_t count = 0;
    uint32_t no = (rt_uint32_t)parameter;

    while (1)
    {
        rt_kprintf("thread%d count: %d\n", no, ++count);
        rt_thread_delay(15);
    }
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    tid1 = rt_thread_create("t1", thread0_entry, (void *)1,
                            THREAD_STACK_SIZE, THREAD_PRIORITY, 2);

    if (tid1 != RT_NULL)
        rt_thread_startup(tid1);

    tid2 = rt_thread_create("t2", thread0_entry, (void *)2,
                            THREAD_STACK_SIZE, THREAD_PRIORITY, 4);

    if (tid2 != RT_NULL)
        rt_thread_startup(tid2);

    tid3 = rt_thread_create("t3", thread1_entry, (void *)3,
                            THREAD_STACK_SIZE, THREAD_PRIORITY - 1, 5);

    if (tid3 != RT_NULL)
        rt_thread_startup(tid3);

    return 0;
}

/**
  * @}
  */
/**
  * @}
  */
