/*
 ****************************************************************************
 *
 *                   "DHRYSTONE" Benchmark Program
 *                   -----------------------------
 *                                                                            
 *  Version:    C, Version 2.1
 *                                                                            
 *  File:       dhry_1.c (part 2 of 3)
 *
 *  Date:       May 25, 1988
 *
 *  Author:     Reinhold P. Weicker
 *
 ****************************************************************************
 */

#include "dhry.h"
#include "utils.h"
#include "ald_cmu.h"
#include "ald_gpio.h"

/* Global Variables: */

Rec_Type rev_env0;
Rec_Type rev_env1;

Rec_Pointer     Ptr_Glob,
                Next_Ptr_Glob;
int             Int_Glob;
Boolean         Bool_Glob;
char            Ch_1_Glob,
                Ch_2_Glob;
int             Arr_1_Glob [35];
int             Arr_2_Glob [35] [35];
int             g_tick_value;
//extern char     *malloc ();
//Enumeration     Func_1 ();
  /* forward declaration necessary since Enumeration may not simply be int */

#ifndef REG
        Boolean Reg = false;
#define REG
        /* REG becomes defined as empty */
        /* i.e. no register variables   */
#else
        Boolean Reg = true;
#endif

/* variables for time measurement: */

#ifdef TIMES
struct tms      time_info;
extern  int     times ();
                /* see library function "times" */
#define Too_Small_Time (2*HZ)
                /* Measurements should last at least about 2 seconds */
#endif
#ifdef __TIME
extern long     time();
                /* see library function "time"  */
#define Too_Small_Time 2
                /* Measurements should last at least 2 seconds */
#endif
#ifdef MSC_CLOCK
//extern clock_t  clock();
#define TICK_PER_SEC	(ald_cmu_get_sys_clock())
#define Too_Small_Time	(2 * TICK_PER_SEC)
#endif

long            Begin_Time,
                End_Time,
                User_Time;
float           Microseconds,
                Dhrystones_Per_Second;
float           dmips;
float           dmhz;

/* end of variables for time measurement */

void Proc_1(REG Rec_Pointer Ptr_Val_Par);
void dhrystone(void);

#define TIME_BY_GPIO

int main()
{
	gpio_init_t x;

	ald_cmu_init();
	ald_cmu_clock_config(CMU_CLOCK_HRC, 24000000);
	ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);
        SysTick->CTRL = (SysTick_CTRL_CLKSOURCE_Msk|SysTick_CTRL_ENABLE_Msk);
        SysTick->LOAD = 0xFFFFFF;
        SysTick->VAL  = 0;    
        
	/* 0-34MHz  ---  0x0
	* 34-65MHz ---  0x1
	* 65-96MHz ---  0x2
	*/
	MSC->MEMWAIT = 0x1;

	x.mode  = GPIO_MODE_OUTPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.podrv = GPIO_OUT_DRIVE_6;
	x.nodrv = GPIO_OUT_DRIVE_6;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_TTL;
	x.func  = GPIO_FUNC_1;
	ald_gpio_init(GPIOC, GPIO_PIN_0, &x);
	ald_gpio_write_pin(GPIOC, GPIO_PIN_0, 1);

        g_tick_value = 0;
        SysTick->CTRL |= (SysTick_CTRL_ENABLE_Msk|SysTick_CTRL_TICKINT_Msk);
	dhrystone();

	while (1) {
		;
	}
}

/*****/

  /* main program, corresponds to procedures        */
  /* Main and Proc_0 in the Ada version             */
void dhrystone(void)
{
	One_Fifty       Int_1_Loc;
  REG   One_Fifty       Int_2_Loc;
        One_Fifty       Int_3_Loc;
  REG   char            Ch_Index;
        Enumeration     Enum_Loc;
        Str_30          Str_1_Loc;
        Str_30          Str_2_Loc;
  REG   int             Run_Index;
  REG   int             Number_Of_Runs;

	/* Initializations */
	Next_Ptr_Glob = (Rec_Pointer)&rev_env0;
	Ptr_Glob = (Rec_Pointer)&rev_env1;

	Ptr_Glob->Ptr_Comp                    = Next_Ptr_Glob;
	Ptr_Glob->Discr                       = Ident_1;
	Ptr_Glob->variant.var_1.Enum_Comp     = Ident_3;
	Ptr_Glob->variant.var_1.Int_Comp      = 40;
	strcpy(Ptr_Glob->variant.var_1.Str_Comp, "DHRYSTONE PROGRAM, SOME STRING");
	strcpy(Str_1_Loc, "DHRYSTONE PROGRAM, 1'ST STRING");

	Arr_2_Glob [8][7] = 10;
        /* Was missing in published program. Without this statement,    */
        /* Arr_2_Glob [8][7] would have an undefined value.             */
        /* Warning: With 16-Bit processors and Number_Of_Runs > 32000,  */
        /* overflow may occur for this array element.                   */

	Number_Of_Runs = 80000;

	/***************/
	/* Start timer */
	/***************/
        
        //Begin_Time = ald_mcu_get_timestamp();
	Begin_Time = SysTick->VAL;

#ifdef TIME_BY_GPIO
	ald_gpio_write_pin(GPIOC, GPIO_PIN_0, 0);
#endif	


	for (Run_Index = 1; Run_Index <= Number_Of_Runs; ++Run_Index) {
		Proc_5();
		Proc_4();
		/* Ch_1_Glob == 'A', Ch_2_Glob == 'B', Bool_Glob == true */
		Int_1_Loc = 2;
		Int_2_Loc = 3;
		strcpy (Str_2_Loc, "DHRYSTONE PROGRAM, 2'ND STRING");
		Enum_Loc = Ident_2;
		Bool_Glob = ! Func_2 (Str_1_Loc, Str_2_Loc);
		/* Bool_Glob == 1 */
		while (Int_1_Loc < Int_2_Loc)  /* loop body executed once */
		{
			Int_3_Loc = 5 * Int_1_Loc - Int_2_Loc;
			/* Int_3_Loc == 7 */
			Proc_7 (Int_1_Loc, Int_2_Loc, &Int_3_Loc);
			/* Int_3_Loc == 7 */
			Int_1_Loc += 1;
		} /* while */
		/* Int_1_Loc == 3, Int_2_Loc == 3, Int_3_Loc == 7 */
		Proc_8 (Arr_1_Glob, Arr_2_Glob, Int_1_Loc, Int_3_Loc);
		/* Int_Glob == 5 */
		Proc_1 (Ptr_Glob);
		for (Ch_Index = 'A'; Ch_Index <= Ch_2_Glob; ++Ch_Index) {
			/* loop body executed twice */
			if (Enum_Loc == Func_1 (Ch_Index, 'C')) {
				/* then, not executed */
				Proc_6 (Ident_1, &Enum_Loc);
				strcpy (Str_2_Loc, "DHRYSTONE PROGRAM, 3'RD STRING");
				Int_2_Loc = Run_Index;
				Int_Glob = Run_Index;
			}
		}
		/* Int_1_Loc == 3, Int_2_Loc == 3, Int_3_Loc == 7 */
		Int_2_Loc = Int_2_Loc * Int_1_Loc;
		Int_1_Loc = Int_2_Loc / Int_3_Loc;
		Int_2_Loc = 7 * (Int_2_Loc - Int_3_Loc) - Int_1_Loc;
		/* Int_1_Loc == 1, Int_2_Loc == 13, Int_3_Loc == 7 */
		Proc_2 (&Int_1_Loc);
		/* Int_1_Loc == 5 */
	} /* loop "for Run_Index" */

	/**************/
	/* Stop timer */
	/**************/

#ifdef TIME_BY_GPIO
	ald_gpio_write_pin(GPIOC, GPIO_PIN_0, 1);
#endif	
        End_Time = SysTick->VAL;
        User_Time = Begin_Time - End_Time;
        User_Time += g_tick_value;
  
#ifdef __TIME
	Microseconds = (float) User_Time * Mic_secs_Per_Second / (float) Number_Of_Runs;
	Dhrystones_Per_Second = (float) Number_Of_Runs / (float) User_Time;
#else
	Microseconds = (float) User_Time * Mic_secs_Per_Second / ((float) TICK_PER_SEC * ((float) Number_Of_Runs));
	Dhrystones_Per_Second = ((float) TICK_PER_SEC * (float) Number_Of_Runs) / (float) User_Time;
	dmips = Dhrystones_Per_Second / 1757.0;
	dmhz  = dmips / (TICK_PER_SEC / 1000000);     
#endif
}

/* executed once */
void Proc_1(REG Rec_Pointer Ptr_Val_Par)
{
  REG Rec_Pointer Next_Record = Ptr_Val_Par->Ptr_Comp;  
                                        /* == Ptr_Glob_Next */
  /* Local variable, initialized with Ptr_Val_Par->Ptr_Comp,    */
  /* corresponds to "rename" in Ada, "with" in Pascal           */
  
  structassign (*Ptr_Val_Par->Ptr_Comp, *Ptr_Glob); 
  Ptr_Val_Par->variant.var_1.Int_Comp = 5;
  Next_Record->variant.var_1.Int_Comp 
        = Ptr_Val_Par->variant.var_1.Int_Comp;
  Next_Record->Ptr_Comp = Ptr_Val_Par->Ptr_Comp;
  Proc_3 (&Next_Record->Ptr_Comp);
    /* Ptr_Val_Par->Ptr_Comp->Ptr_Comp 
                        == Ptr_Glob->Ptr_Comp */
  if (Next_Record->Discr == Ident_1)
    /* then, executed */
  {
    Next_Record->variant.var_1.Int_Comp = 6;
    Proc_6 (Ptr_Val_Par->variant.var_1.Enum_Comp, 
           &Next_Record->variant.var_1.Enum_Comp);
    Next_Record->Ptr_Comp = Ptr_Glob->Ptr_Comp;
    Proc_7 (Next_Record->variant.var_1.Int_Comp, 10, 
           &Next_Record->variant.var_1.Int_Comp);
  }
  else /* not executed */
    structassign (*Ptr_Val_Par, *Ptr_Val_Par->Ptr_Comp);
} /* Proc_1 */

/* executed once */
/* *Int_Par_Ref == 1, becomes 4 */
void Proc_2(One_Fifty *Int_Par_Ref)
{
  One_Fifty  Int_Loc;  
  Enumeration   Enum_Loc;

  Int_Loc = *Int_Par_Ref + 10;
  do /* executed once */
    if (Ch_1_Glob == 'A')
      /* then, executed */
    {
      Int_Loc -= 1;
      *Int_Par_Ref = Int_Loc - Int_Glob;
      Enum_Loc = Ident_1;
    } /* if */
  while (Enum_Loc != Ident_1); /* true */
} /* Proc_2 */

/* executed once */
/* Ptr_Ref_Par becomes Ptr_Glob */
void Proc_3(Rec_Pointer *Ptr_Ref_Par)
{
  if (Ptr_Glob != Null)
    /* then, executed */
    *Ptr_Ref_Par = Ptr_Glob->Ptr_Comp;
  Proc_7 (10, Int_Glob, &Ptr_Glob->variant.var_1.Int_Comp);
} /* Proc_3 */

/* executed once */
/* without parameters */
void Proc_4(void)
{
  Boolean Bool_Loc;

  Bool_Loc = Ch_1_Glob == 'A';
  Bool_Glob = Bool_Loc | Bool_Glob;
  Ch_2_Glob = 'B';
} /* Proc_4 */

/* executed once */
/* without parameters */
void Proc_5(void)
{
  Ch_1_Glob = 'A';
  Bool_Glob = false;
} /* Proc_5 */


        /* Procedure for the assignment of structures,          */
        /* if the C compiler doesn't support this feature       */
#ifdef  NOSTRUCTASSIGN
memcpy (d, s, l)
register char   *d;
register char   *s;
register int    l;
{
        while (l--) *d++ = *s++;
}
#endif

