/**
  *********************************************************************************
  *
  * @file    tk_uart.h
  * @brief   Header file for TK DEMO
  *
  * @version V1.0
  * @date    2 Dec 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
    *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#ifndef   __UART_H__
#define   __UART_H__

#include "stdint.h"
#include "ald_uart.h"
#include "ald_usart.h"
#include "ald_lpuart.h"
#include "tkm_config.h"

#if TK_UARToutput_function == ON
    //      UART
    #define  UART_FUNC          GPIO_FUNC_4
    #define  UART_PORT          GPIOA
    #define  UART_TX                      GPIO_PIN_13
    #define  UART_RX                      GPIO_PIN_14
    //    USART
    //    #define  UART_FUNC          GPIO_FUNC_3
    //    #define  UART_PORT          GPIOA
    //    #define  UART_TX                      GPIO_PIN_2
    //    #define  UART_RX                      GPIO_PIN_3
    //    LPUART
//    #define  UART_FUNC          GPIO_FUNC_4
//    #define  UART_PORT          GPIOB
//    #define  UART_TX            GPIO_PIN_10
//    #define  UART_RX            GPIO_PIN_11

    #define  SLAVE_ADDR     0x4E        //ӻַ
    #define  COMMOND0       0x51        //0ͨ
    #define  COMMOND1       0x5A        //1
    #define  COMMOND2       0x5B        //2˲
    #define  COMMOND3       0x5C        //3
    #define  COMMOND4       0x50        //4ֵ
    #define  COMMOND5       0x52        //5
    #define  COMMOND6       0x53        //6ȡоƬͺ
    #define  COMMOND7       0x5D        //7оƬλ
    #if TK_UART_TYPE == TKM_UART
        extern uart_handle_t h_uart_tk;
    #endif
    #if TK_UART_TYPE == TKM_USART
        extern usart_handle_t h_usart0_tk;
    #endif
    #if TK_UART_TYPE == TKM_LPUART
        extern lpuart_handle_t h_lpuart_tk;
    #endif
    extern uint8_t Cnt_Mask;
    extern uint32_t ChannelMask;
    extern uint8_t g_com;               //
    extern uint8_t g_length;            //ݳ
    extern uint8_t g_rp;                //ָ
    extern uint8_t g_tp;                //ָ
    extern uint8_t g_checksum;          //У
    extern uint8_t Tx_timer;
    extern uint8_t Rx_timer;
    extern uint8_t UploadSampByte[(TK_NUM * 2) + 5]; //ֽ
    extern uint8_t UploadRawByte[(TK_NUM * 2) + 5];  //˲ֽ
    extern uint8_t UploadBaseByte[(TK_NUM * 2) + 5]; //ֽ
    #if ((TK_NUM*2)+5) < 14
        extern uint8_t UploadBuf[14];       //ͻ
    #else
        extern uint8_t UploadBuf[(TK_NUM * 2) + 5];     //ͻ
    #endif
    extern uint8_t Uart_ready;
    #if TK_UART_TYPE == TKM_UART
        extern void UART_Init_tk(void);
    #endif
    #if TK_UART_TYPE == TKM_USART
        extern void USART_Init_tk(void);
    #endif
    #if TK_UART_TYPE == TKM_LPUART
        extern void LPUART_Init_tk(void);
    #endif

    #if TK_Lowpowermode == ON
        extern uint8_t uart_send_flag;
        #if TK_LP_dataprocess_mode  == Merge
            extern uint16_t TK_md2value_origin;
        #endif
        #if TK_LP_dataprocess_mode == Poll
            extern uint16_t TK_md2value_origin[TK_NUM];
        #endif
    #endif

#endif

#endif
