/**
  *********************************************************************************
  *
  * @file    tk_low_power.h
  * @brief   Header file for TK DEMO
  *
  * @version V1.1
  * @date    18 Oct 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          2 Dec 2021      AE Team         The first version
  *          18 Oct 2023     AE Team         Add some variables
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#ifndef   __TK_LOW_POWER_H__
#define   __TK_LOW_POWER_H__

#include "stdint.h"
#include "ald_lptim.h"
#include "tkm_config.h"

#if TK_Lowpowermode == ON

    extern lptim_handle_t h_lptim;
    extern uint8_t g_tk_done_if;
    extern uint8_t TK_Sleep_cnt;
    extern uint8_t g_wakeup_flag;
    #if TK_LP_dataprocess_mode == Merge
        extern uint16_t TK_md2average_backup;
        extern uint16_t sleep_first_data;
        extern uint16_t sleep_jitter_data;
        extern uint16_t lp_base_err_cnt;
    #endif
    #if TK_LP_dataprocess_mode == Poll
        extern uint16_t TK_md2average_backup[TK_NUM_LP];
        extern uint16_t sleep_first_data[TK_NUM_LP];
        extern uint16_t sleep_jitter_data[TK_NUM_LP];
        extern uint16_t lp_base_err_cnt[TK_NUM_LP];
    #endif
    extern uint16_t TK_mode1_nopresstimer;

    extern void TKS_init(void);
    extern void PIS_init(void);
    extern void LPTIM_init(void);
    extern void TKStandby(void);

#endif

#endif
