/**
  *********************************************************************************
  *
  * @file    lptimer.c
  * @brief   timer
  *
  * @version V1.0.0
  * @date    13 May 2022
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          13 May 2022     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  *********************************************************************************
  */

#include "lptimer.h"
#include "lcd.h"

lptim_handle_t h_lptim;
uint8_t cnt;

void lptim_handle(struct lptim_handle_s *arg)
{
    cnt++;
    lcd_num_dis(cnt, cnt, cnt, cnt);

    if (cnt == 9)
    {
        cnt = 0;
    }
}

void lptim_init(void)
{
    ald_cmu_perh_clock_config(CMU_PERH_LPTIM0, ENABLE);

    ald_mcu_irq_config(LP16T0_IRQn, 1, ENABLE);

    h_lptim.perh        = LPTIM0;
    h_lptim.init.psc    = LPTIM_PRESC_128;
    h_lptim.init.mode   = LPTIM_MODE_CONTINUOUS;
    h_lptim.init.arr    = 256;
    h_lptim.init.cmp    = 100;
    h_lptim.init.clock  = CMU_LP_PERH_CLOCK_SEL_LRC;
    h_lptim.update_cbk  = lptim_handle;
    ald_lptim_pulse_init(&h_lptim);

    cnt = 0;

    ald_lptim_base_start_by_it(&h_lptim);
}
