/**
  *********************************************************************************
  *
  * @file    uart.c
  * @brief   uart moudle for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include <string.h>
#include "ald_cmu.h"
#include "ald_gpio.h"
#include "ald_uart.h"
#include "uart.h"

uart_handle_t h_uart;
uint8_t tx_buf[100];
uint8_t rx_buf[100];
/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
void uart_pin_init(void)
{
    gpio_init_t x;
    memset(&x, 0x0, sizeof(x));

    ald_cmu_perh_clock_config(CMU_PERH_GPIO, ENABLE);

    /* Initialize tx pin */
    x.mode = GPIO_MODE_OUTPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = GPIO_FUNC_4;
    ald_gpio_init(GPIOA, GPIO_PIN_13, &x);

    /* Initialize rx pin */
    x.mode = GPIO_MODE_INPUT;
    x.odos = GPIO_PUSH_PULL;
    x.pupd = GPIO_PUSH_UP;
    x.podrv = GPIO_OUT_DRIVE_1;
    x.nodrv = GPIO_OUT_DRIVE_0_1;
    x.flt  = GPIO_FILTER_DISABLE;
    x.type = GPIO_TYPE_TTL;
    x.func = GPIO_FUNC_4;
    ald_gpio_init(GPIOA, GPIO_PIN_14, &x);

    return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_send_complete(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_recv_complete(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Send and receive a message complete.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_send_recv_complete(uart_handle_t *arg)
{
    return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to uart_handle_t structure.
  * @retval None.
  */
void uart_error(uart_handle_t *arg)
{
    return;
}

/**
  * @brief:  Initialize the UART.
  * @param:  None
  * @retval: None
  */
void UART_Init(void)
{
    /* clear uart_handle_t structure */
    memset(&h_uart, 0x0, sizeof(h_uart));

    /* Initialize tx_buf */
    memset(tx_buf, 0x55, sizeof(tx_buf));

    /* Initialize pin */
    uart_pin_init();

    ald_cmu_perh_clock_config(CMU_PERH_UART0, ENABLE);

    /* Initialize uart */
    h_uart.perh             = UART0;
    h_uart.init.baud        = 115200;
    h_uart.init.word_length = UART_WORD_LENGTH_8B;
    h_uart.init.stop_bits   = UART_STOP_BITS_1;
    h_uart.init.parity      = UART_PARITY_NONE;
    h_uart.init.mode        = UART_MODE_UART;
    h_uart.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    h_uart.tx_cplt_cbk      = uart_send_complete;
    h_uart.rx_cplt_cbk      = uart_recv_complete;
    h_uart.error_cbk        = uart_error;
    ald_uart_init(&h_uart);
}
