/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Apr 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Apr 2021     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */

#include "ald_cmu.h"
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Main function
  * @retval Status
  */
int main()
{
    uint8_t i;
    /* Initialize ALD */
    ald_cmu_init();
    /* must use HOSC */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_6, CMU_PLL1_OUTPUT_48M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

    UART_Init();

    FDET_Init();

    PIS_Init();

    Timer_Init();

    while (1)
    {
        if (full_data)
        {
            for (i = 0; i < 100; i++)
            {
                tx_buf[2 * i] = (uint8_t)(data_result[i] >> 8);
                tx_buf[2 * i + 1] = (uint8_t)(data_result[i]);
            }

            /* Send a message */
            ald_uart_send(&h_uart, tx_buf, 100, 1000);
            full_data = 0;
        }

        ald_delay_ms(1000);
    }
}
/**
  * @}
  */
/**
  * @}
  */
