/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */
volatile uint32_t result;
md_trng_init_t init;
/** @addtogroup Public_Function
  * @{
  */
/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Configure system clock */
	md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_72M);
	md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 72000000);
	/* PriorityGroup_2 */
	NVIC_SetPriorityGrouping(5); 
	/* Initialize SysTick Interrupt */
	md_init_1ms_tick();

	/* Enable ALL peripheral */
	SYSCFG_UNLOCK();
	md_cmu_enable_perh_all();
	SYSCFG_LOCK();

	/* Init trng struct */
	md_trng_struct_init(&init);
	/* Initialize trng */
	md_trng_init(&init);
	/* Start calculating random */
	md_trng_enable_trngen(TRNG);

	/* Waiting flag */
	while (!(md_trng_is_active_flag_davld(TRNG)));
	/* Get the result */
	result = md_trng_get_data(TRNG);

	while (1) {
		while (!(md_trng_is_active_flag_davld(TRNG)));
		result = md_trng_get_data(TRNG);
	}
}

/**
  * @}
  */
/**
  * @}
  */
