/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "md_conf.h"
#include <string.h>

#define TIMER_GPIO_PORT GPIOA
#define TIMER_GPIO_PIN  MD_GPIO_PIN_15

#define  PERIOD_VALUE	(uint32_t)(90 - 1)   			//pwmڣƵ = 72000000 / (PERIOD_VALUE+1)
#define  PWM_TEN	(uint32_t)(PERIOD_VALUE * 10 / 100)	//pwmռձ10%
#define  PWM_HALF	(uint32_t)(PERIOD_VALUE * 50 / 100)	//pwmռձ50% 
#define  PWM_SIZE	(uint32_t)720				//pwm鳤 

#endif
