/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

md_rtc_time_t time;
md_rtc_date_t date;

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	md_rtc_init_t init;

	/* Configure system clock */
	md_cmu_clock_config_default();
	/* PriorityGroup_2 */
	NVIC_SetPriorityGrouping(5); 
	/* Initialize SysTick Interrupt */
	md_init_1ms_tick();
	/* Set PCLK2 frequency */
	md_cmu_div_config(MD_CMU_PCLK_2, MD_CMU_DIV_2);

	/* Enable ALL peripheral */
	SYSCFG_UNLOCK();
	md_cmu_enable_perh_all();
	SYSCFG_LOCK();

	/* Set LOSM as RTC clock */
	md_bkpc_rtc_clock_config(MD_BKPC_PREH_CLK_LOSM);

	/* Initialize RTC */
	md_rtc_struct_init(&init);
	md_rtc_init(&init);
	
	/* Initialize time/date */
	md_rtc_time_struct_init(&time);
	md_rtc_date_struct_init(&date);
	md_rtc_set_time(&time, MD_RTC_FORMAT_DEC);
	md_rtc_set_date(&date, MD_RTC_FORMAT_DEC);

	while (1) {
		/* Get time/date each second */
		md_delay_1ms(1000);
		md_rtc_get_time(&time, MD_RTC_FORMAT_DEC);
		md_rtc_get_date(&date, MD_RTC_FORMAT_DEC);
	}
}

/**
  * @}
  */
/**
  * @}
  */
