/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    19 Feb 2019
  * @author  AE Team
  * @note   
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */ 

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint8_t tx_buf[32];
uint8_t rx_buf[32];

/**
  * @brief  Initializate pin.
  * @retval None
  */
void gpio_pin_init(void)
{
	md_gpio_init_t x;

	/* Initialize tx pin */
	x.mode  = MD_GPIO_MODE_OUTPUT;
	x.odos  = MD_GPIO_PUSH_PULL;
	x.pupd  = MD_GPIO_PUSH_UP;
	x.podrv = MD_GPIO_OUT_DRIVE_6;
	x.nodrv = MD_GPIO_OUT_DRIVE_6;
	x.flt   = MD_GPIO_FILTER_DISABLE;
	x.type  = MD_GPIO_TYPE_TTL;
	x.func  = MD_GPIO_FUNC_1;
	md_gpio_init(GPIOC, MD_GPIO_PIN_0, &x);

	/* Initialize rx pin */
	x.mode  = MD_GPIO_MODE_INPUT;
	x.odos  = MD_GPIO_PUSH_PULL;
	x.pupd  = MD_GPIO_PUSH_UP;
	x.podrv = MD_GPIO_OUT_DRIVE_6;
	x.nodrv = MD_GPIO_OUT_DRIVE_6;
	x.flt   = MD_GPIO_FILTER_DISABLE;
	x.type  = MD_GPIO_TYPE_TTL;
	x.func  = MD_GPIO_FUNC_1;
	md_gpio_init(GPIOC, MD_GPIO_PIN_1, &x);

	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Configure system clock */
	md_cmu_clock_config_default();
	/* PriorityGroup_2 */
	NVIC_SetPriorityGrouping(5); 
	/* Initialize SysTick Interrupt */
	md_init_1ms_tick();

	/* Enable ALL peripheral */
	SYSCFG_UNLOCK();
	md_cmu_enable_perh_all();
	SYSCFG_LOCK();

	/* Initialize pin */
	gpio_pin_init();

	md_gpio_set_pin_high(GPIOC, MD_GPIO_PIN_0);
	md_gpio_set_pin_low(GPIOC, MD_GPIO_PIN_0);
	md_gpio_set_pin_high(GPIOC, MD_GPIO_PIN_0);
	md_gpio_set_pin_low(GPIOC, MD_GPIO_PIN_0);
	md_gpio_toggle_pin_output(GPIOC, MD_GPIO_PIN_0);
	md_gpio_toggle_pin_output(GPIOC, MD_GPIO_PIN_0);

	tx_buf[0] = md_gpio_get_input_data(GPIOC, MD_GPIO_PIN_1);
	tx_buf[0] = md_gpio_get_input_data(GPIOC, MD_GPIO_PIN_1);
	tx_buf[0] = md_gpio_get_input_data(GPIOC, MD_GPIO_PIN_1);
	tx_buf[0] = md_gpio_get_input_data(GPIOC, MD_GPIO_PIN_1);

	while (1) {
		md_delay_1ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
