/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"


#define CARD_IO5_PORT	GPIOA
#define CARD_IO5_PIN	GPIO_PIN_2
#define CARD_RST_PORT	GPIOA
#define CARD_RST_PIN	GPIO_PIN_1
#define CARD_CLK_PORT	GPIOA
#define CARD_CLK_PIN	GPIO_PIN_4
#define CARD_IO0_PORT	GPIOB
#define CARD_IO0_PIN	GPIO_PIN_10


#define DISABLE_UART_RX(hperh)	(CLEAR_BIT(hperh->perh->LCON, UART_LCON_RXEN_MSK))
#define DISABLE_UART_TX(hperh)	(CLEAR_BIT(hperh->perh->LCON, UART_LCON_TXEN_MSK))
#define ENABLE_UART_RX(hperh)	(SET_BIT(hperh->perh->LCON, UART_LCON_RXEN_MSK))
#define ENABLE_UART_TX(hperh)	(SET_BIT(hperh->perh->LCON, UART_LCON_TXEN_MSK))

#endif
