/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

timer_handle_t h_tim;
timer_clock_config_t tim_clock;
timer_oc_init_t tim_ocinit;
timer_break_dead_time_t config;

#define  PERIOD_VALUE       (uint32_t)(700 - 1)  		/* Period Value  */
#define  PULSE1_VALUE       (uint32_t)(PERIOD_VALUE/2)		/* Capture Compare 1 Value  */
#define  PULSE2_VALUE       (uint32_t)(PERIOD_VALUE*37.5/100)	/* Capture Compare 2 Value  */
#define  PULSE3_VALUE       (uint32_t)(PERIOD_VALUE/4)		/* Capture Compare 3 Value  */
#define  PULSE4_VALUE       (uint32_t)(PERIOD_VALUE*12.5/100)	/* Capture Compare 4 Value  */
/**
  * @brief  Initializate pin of tim module.
  * @retval None
  */
void tim_pin_init(void)
{
	gpio_init_t x;

	/* Initialize tim0 ch1 pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.odos = GPIO_PUSH_PULL;
	x.pupd = GPIO_PUSH_UP;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.nodrv = GPIO_OUT_DRIVE_6;
	x.podrv = GPIO_OUT_DRIVE_6;
	x.func = GPIO_FUNC_2;

	ald_gpio_init(TIMER_CHANNEL_PORT, TIMER_CHANNEL1_PIN, &x);
        ald_gpio_init(TIMER_CHANNEL_PORT, TIMER_CHANNEL1N_PIN, &x);
        ald_gpio_init(TIMER_CHANNEL_PORT, TIMER_CHANNEL2_PIN, &x);
        ald_gpio_init(TIMER_CHANNEL_PORT, TIMER_CHANNEL2N_PIN, &x);
        ald_gpio_init(TIMER_CHANNEL_PORT, TIMER_CHANNEL3_PIN, &x);
        ald_gpio_init(TIMER_CHANNEL_PORT, TIMER_CHANNEL3N_PIN, &x);

        x.mode = GPIO_MODE_INPUT;
	x.pupd = GPIO_PUSH_DOWN;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_TTL;
	x.func = GPIO_FUNC_2;
        ald_gpio_init(TIMER_BREAK_PORT, TIMER_BREAK_PIN, &x);
}


/**
  * @brief  This is main function
  * @retval Status
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
        ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1,48000000);
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);
        /* Initialize pin */
	tim_pin_init();

	/* Initialize TIM0 */
	h_tim.perh           = AD16C4T0;
	h_tim.init.prescaler = 0;
	h_tim.init.mode      = TIMER_CNT_MODE_UP;
	h_tim.init.period    = PERIOD_VALUE;
	h_tim.init.clk_div   = TIMER_CLOCK_DIV1;
	h_tim.init.re_cnt    = 0;
	ald_timer_pwm_init(&h_tim);

	/* Initialize clock source */
	tim_clock.source = TIMER_SRC_INTER;
	ald_timer_config_clock_source(&h_tim, &tim_clock);

	/* Common configuration for all channels */
	tim_ocinit.oc_mode        = TIMER_OC_MODE_PWM1;
        tim_ocinit.oc_polarity    = TIMER_OC_POLARITY_HIGH;
        tim_ocinit.ocn_polarity   = TIMER_OCN_POLARITY_HIGH;
        tim_ocinit.oc_idle        = TIMER_OC_IDLE_SET;
        tim_ocinit.ocn_idle       = TIMER_OCN_IDLE_RESET;
        tim_ocinit.oc_fast_en     = DISABLE;

        /* Set the pulse value for channel 1 */
        tim_ocinit.pulse = PULSE1_VALUE;
	ald_timer_oc_config_channel(&h_tim, &tim_ocinit, TIMER_CHANNEL_1);
        /* Set the pulse value for channel 2 */
        tim_ocinit.pulse = PULSE2_VALUE;
	ald_timer_oc_config_channel(&h_tim, &tim_ocinit, TIMER_CHANNEL_2);
        /* Set the pulse value for channel 3 */
        tim_ocinit.pulse = PULSE3_VALUE;
	ald_timer_oc_config_channel(&h_tim, &tim_ocinit, TIMER_CHANNEL_3);

        /* Set the Break feature & Dead time */
        config.break_state = ENABLE;
        config.dead_time   = 50;
        config.off_run     = ENABLE;
        config.off_idle    = ENABLE;
        config.lock_level  = TIMER_LOCK_LEVEL_1;
        config.polarity    = TIMER_BREAK_POLARITY_HIGH;
        config.auto_out    = ENABLE;
        ald_timer_break_dead_time_config(&h_tim, &config);

	/* Start input pwm from tim0 channel 1 */
        ald_timer_pwm_start(&h_tim, TIMER_CHANNEL_1);
        ald_timer_pwmn_start(&h_tim, TIMER_CHANNEL_1);
        /* Start channel 2 */
        ald_timer_pwm_start(&h_tim, TIMER_CHANNEL_2);
        ald_timer_pwmn_start(&h_tim, TIMER_CHANNEL_2);
        /* Start input pwm from tim0 channel 3 */
        ald_timer_pwm_start(&h_tim, TIMER_CHANNEL_3);
        ald_timer_pwmn_start(&h_tim, TIMER_CHANNEL_3);

	while(1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
