/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include <string.h>
#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

spi_handle_t h_spi;
uint8_t tx_buf[8];
uint8_t rx_buf[8];

/**
  * @brief  Initializate pin of spi module.
  * @retval None
  */
void spi_pin_init(void)
{
	gpio_init_t x;

	/* Initialize nss pin */
	x.mode  = GPIO_MODE_OUTPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.podrv = GPIO_OUT_DRIVE_1;
	x.nodrv = GPIO_OUT_DRIVE_1;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_TTL;
	x.func  = GPIO_FUNC_1;
	ald_gpio_init(GPIOC, GPIO_PIN_0, &x);

	/* Initialize sck pin */
	x.mode  = GPIO_MODE_OUTPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.podrv = GPIO_OUT_DRIVE_1;
	x.nodrv = GPIO_OUT_DRIVE_1;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_TTL;
	x.func  = GPIO_FUNC_4;
	ald_gpio_init(GPIOC, GPIO_PIN_1, &x);

	/* Initialize miso pin */
	x.mode  = GPIO_MODE_INPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.podrv = GPIO_OUT_DRIVE_1;
	x.nodrv = GPIO_OUT_DRIVE_1;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_TTL;
	x.func  = GPIO_FUNC_4;
	ald_gpio_init(GPIOC, GPIO_PIN_2, &x);

	/* Initialize mosi pin */
	x.mode  = GPIO_MODE_OUTPUT;
	x.odos  = GPIO_PUSH_PULL;
	x.pupd  = GPIO_PUSH_UP;
	x.podrv = GPIO_OUT_DRIVE_1;
	x.nodrv = GPIO_OUT_DRIVE_1;
	x.flt   = GPIO_FILTER_DISABLE;
	x.type  = GPIO_TYPE_TTL;
	x.func  = GPIO_FUNC_4;
	ald_gpio_init(GPIOC, GPIO_PIN_3, &x);

	return;
}

/**
  * @brief  Send message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_send_complete(spi_handle_t *arg)
{
	return;
}

/**
  * @brief  Receive a message complete.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_recv_complete(spi_handle_t *arg)
{
	return;
}

/**
  * @brief  Occurs error.
  * @param  arg: Pointer to spi_handle_t structure.
  * @retval None.
  */
void spi_error(spi_handle_t *arg)
{
	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);	
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	/* clear spi_handle_t structure */
	memset(&h_spi, 0x0, sizeof(h_spi));
	/* Initialize pin */
	spi_pin_init();
	/* Initialize tx_buf */
	memset(tx_buf, 0x55, sizeof(tx_buf));

	/* Initialize spi */
	h_spi.perh           = SPI1;
	h_spi.init.mode      = SPI_MODE_MASTER;
	h_spi.init.dir	     = SPI_DIRECTION_2LINES;
	h_spi.init.data_size = SPI_DATA_SIZE_8;
	h_spi.init.baud      = SPI_BAUD_64;
	h_spi.init.phase     = SPI_CPHA_FIRST;
	h_spi.init.polarity  = SPI_CPOL_HIGH;
	h_spi.init.first_bit = SPI_FIRSTBIT_MSB;
	h_spi.init.ss_en     = DISABLE;
	h_spi.init.crc_calc  = DISABLE;
	h_spi.tx_cplt_cbk    = spi_send_complete;
	h_spi.rx_cplt_cbk    = spi_send_complete;
	h_spi.err_cbk        = spi_error;
	ald_spi_init(&h_spi);

	/* cs pin set low */
	ald_gpio_write_pin(GPIOC, GPIO_PIN_0, 0);
	/* Send/Receive a message  */
	ald_spi_send_recv_by_dma(&h_spi, tx_buf, rx_buf, sizeof(tx_buf), 0, 1);
	/* cs pin set high */
	ald_gpio_write_pin(GPIOC, GPIO_PIN_0, 1);

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
