/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"
#include "w25q128fv.h"

#define QSPI_PORT	GPIOB

#define QSPI_NSS0_PIN	GPIO_PIN_12
#define QSPI_SCK_PIN	GPIO_PIN_13
#define QSPI_IO0_PIN	GPIO_PIN_14
#define QSPI_IO1_PIN	GPIO_PIN_15
#define QSPI_IO2_PIN	GPIO_PIN_10
#define QSPI_IO3_PIN	GPIO_PIN_11

#define reg00  *(volatile uint32_t *)0x4000D400
#define reg04  *(volatile uint32_t *)0x4000D404
#define reg08  *(volatile uint32_t *)0x4000D408
#define reg0C  *(volatile uint32_t *)0x4000D40C
#define reg10  *(volatile uint32_t *)0x4000D410
#define reg14  *(volatile uint32_t *)0x4000D414
#define reg18  *(volatile uint32_t *)0x4000D418
#define reg1C  *(volatile uint32_t *)0x4000D41C
#define reg20  *(volatile uint32_t *)0x4000D420
#define reg24  *(volatile uint32_t *)0x4000D424
#define reg28  *(volatile uint32_t *)0x4000D428
#define reg2C  *(volatile uint32_t *)0x4000D42C
#define reg30  *(volatile uint32_t *)0x4000D430
#define reg34  *(volatile uint32_t *)0x4000D434
#define reg38  *(volatile uint32_t *)0x4000D438
#define reg3C  *(volatile uint32_t *)0x4000D43C
#define reg40  *(volatile uint32_t *)0x4000D440
#define reg44  *(volatile uint32_t *)0x4000D444
#define reg50  *(volatile uint32_t *)0x4000D450
#define reg54  *(volatile uint32_t *)0x4000D454
#define reg58  *(volatile uint32_t *)0x4000D458
#define reg60  *(volatile uint32_t *)0x4000D460
#define reg64  *(volatile uint32_t *)0x4000D464
#define reg68  *(volatile uint32_t *)0x4000D468
#define reg6C  *(volatile uint32_t *)0x4000D46C
#define reg70  *(volatile uint32_t *)0x4000D470
#define reg74  *(volatile uint32_t *)0x4000D474
#define reg78  *(volatile uint32_t *)0x4000D478
#define reg7C  *(volatile uint32_t *)0x4000D47C
#define reg80  *(volatile uint32_t *)0x4000D480
#define reg90  *(volatile uint32_t *)0x4000D490
#define reg94  *(volatile uint32_t *)0x4000D494
#define regA0  *(volatile uint32_t *)0x4000D4A0
#define regA4  *(volatile uint32_t *)0x4000D4A4
#define regA8  *(volatile uint32_t *)0x4000D4A8
#define regAC  *(volatile uint32_t *)0x4000D4AC
#define regB0  *(volatile uint32_t *)0x4000D4B0
#define regFC  *(volatile uint32_t *)0x4000D4FC

typedef void (*complete_cbk)(void);

/** 
  * @brief Environment variale
  */
typedef struct env_s {
	spi_handle_t h_spi;      /**< SPI handle */
	uint32_t len;            /**< total length */
	uint16_t _len;           /**< Current transfer length */
	uint8_t dma_ch;          /**< DMA channel */

	complete_cbk cbk;        /**< Transfer complete callback */
} env_t;

extern env_t env;


#endif
