/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for demo
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"

/* KEY1 ---> UP
 * KEY2 ---> DOWN
 * KEY3 ---> MID
 * KEY4 ---> LEFT
 * KEY5 ---> RIGHT
 */
#define BSP_KEY_MAX	5
#define BSP_KEY1_PORT	GPIOB
#define BSP_KEY1_PIN	GPIO_PIN_2
#define BSP_KEY2_PORT	GPIOB
#define BSP_KEY2_PIN	GPIO_PIN_12
#define BSP_KEY3_PORT	GPIOC
#define BSP_KEY3_PIN	GPIO_PIN_10
#define BSP_KEY4_PORT	GPIOC
#define BSP_KEY4_PIN	GPIO_PIN_11
#define BSP_KEY5_PORT	GPIOC
#define BSP_KEY5_PIN	GPIO_PIN_12
#define BSP_LED1_PORT	GPIOF
#define BSP_LED1_PIN	GPIO_PIN_0
#define BSP_LED2_PORT	GPIOF
#define BSP_LED2_PIN	GPIO_PIN_1
#define BSP_ADC_PORT	GPIOA
#define BSP_ADC_PIN	GPIO_PIN_5



/**
  * @brief Index of the light
  */
typedef enum {
	BSP_LIGHT_1 = 0,		/**< light 1 */
	BSP_LIGHT_2 = 1,		/**< light 2 */
} bsp_light_idx_t;

/**
  * @brief Event of the light
  */
typedef enum {
	BSP_LIGHT_ON     = 0,		/**< ON */
	BSP_LIGHT_OFF    = 1,		/**< OFF */
	BSP_LIGHT_TOGGLE = 2,		/**< Toggle */
} bsp_light_ctrl_t;

/**
  * @brief Event of key
  */
typedef enum {
	BSP_KEY1_PRESS   = 0,		/**< KEY1 press */
	BSP_KEY1_RELEASE = 1,		/**< KEY1 release */
	BSP_KEY2_PRESS   = 2,		/**< KEY2 press */
	BSP_KEY2_RELEASE = 3,		/**< KEY2 release */
	BSP_KEY3_PRESS   = 4,		/**< KEY3 press */
	BSP_KEY3_RELEASE = 5,		/**< KEY3 release */
	BSP_KEY4_PRESS   = 6,		/**< KEY4 press */
	BSP_KEY4_RELEASE = 7,		/**< KEY4_release */
	BSP_KEY5_PRESS   = 8,		/**< KEY4 press */
	BSP_KEY5_RELEASE = 9,		/**< KEY4_release */
	BSP_KEY_ALL      = 0xFF,	/**< ALL event */
} bsp_key_event_t;

typedef void (*bsp_key_cbk_t)(bsp_key_event_t event);
typedef uint8_t (*bsp_key_read_cbk_t)(void);

/**
  * @brief Key state
  */
typedef union {
	struct {
		uint8_t press :1;	/**< Key press */
		uint8_t hold  :3;	/**< Hold times */
		uint8_t rsv   :4;	/**< Reserve */
	};
	uint8_t Byte;
} bsp_key_state_t;

/**
  * @brief Key environment variable
  */
typedef struct {
	uint32_t valid;					/**< Bit feild */
	bsp_key_state_t state[BSP_KEY_MAX];		/**< Key's state */
	bsp_key_read_cbk_t read_cbk[BSP_KEY_MAX];	/**< Read key callback */
	bsp_key_cbk_t cbk[BSP_KEY_MAX << 1];		/**< Callback of the event */
} bsp_key_env_t;

#endif
