/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __MAIN_H__
#define   __MAIN_H__

#include "ald_conf.h"
#include <string.h>


#define 	EBI_SRAM_ADDRESS_PORTn		19
#define		EBI_SRAM_ADDRESS_PINn		19
#define		EBI_SRAM_DATA_PORTn		16
#define		EBI_SRAM_DATA_PINn		16	
	

#define 	EBI_A0_PORT			GPIOC
#define 	EBI_A0_PIN			GPIO_PIN_0 
#define 	EBI_A1_PORT			GPIOC
#define 	EBI_A1_PIN			GPIO_PIN_1 
#define 	EBI_A2_PORT			GPIOC
#define 	EBI_A2_PIN			GPIO_PIN_2 
#define 	EBI_A3_PORT			GPIOC
#define 	EBI_A3_PIN			GPIO_PIN_3 
#define 	EBI_A4_PORT			GPIOA
#define 	EBI_A4_PIN			GPIO_PIN_4 
#define 	EBI_A5_PORT			GPIOA
#define 	EBI_A5_PIN			GPIO_PIN_5 
#define 	EBI_A6_PORT			GPIOA
#define 	EBI_A6_PIN			GPIO_PIN_6 
#define 	EBI_A7_PORT			GPIOA
#define 	EBI_A7_PIN			GPIO_PIN_7 
#define 	EBI_A8_PORT			GPIOC
#define 	EBI_A8_PIN			GPIO_PIN_4 
#define 	EBI_A9_PORT			GPIOC
#define 	EBI_A9_PIN			GPIO_PIN_5 
#define 	EBI_A10_PORT			GPIOB
#define 	EBI_A10_PIN			GPIO_PIN_10 
#define 	EBI_A11_PORT			GPIOB
#define 	EBI_A11_PIN			GPIO_PIN_11 
#define 	EBI_A12_PORT			GPIOB
#define 	EBI_A12_PIN			GPIO_PIN_12 
#define 	EBI_A13_PORT			GPIOB
#define 	EBI_A13_PIN			GPIO_PIN_13 
#define 	EBI_A14_PORT			GPIOB
#define 	EBI_A14_PIN			GPIO_PIN_14 
#define 	EBI_A15_PORT			GPIOB
#define 	EBI_A15_PIN			GPIO_PIN_15 
#define 	EBI_A16_PORT			GPIOD
#define 	EBI_A16_PIN			GPIO_PIN_11 
#define 	EBI_A17_PORT			GPIOD
#define 	EBI_A17_PIN			GPIO_PIN_12 
#define 	EBI_A18_PORT			GPIOD
#define 	EBI_A18_PIN			GPIO_PIN_13 

	
#define 	EBI_D0_PORT			GPIOD
#define 	EBI_D0_PIN			GPIO_PIN_14
#define 	EBI_D1_PORT			GPIOD
#define 	EBI_D1_PIN			GPIO_PIN_15
#define 	EBI_D2_PORT			GPIOD
#define 	EBI_D2_PIN			GPIO_PIN_0
#define 	EBI_D3_PORT			GPIOD
#define 	EBI_D3_PIN			GPIO_PIN_1
#define 	EBI_D4_PORT			GPIOE
#define 	EBI_D4_PIN			GPIO_PIN_7
#define 	EBI_D5_PORT			GPIOE
#define 	EBI_D5_PIN			GPIO_PIN_8
#define 	EBI_D6_PORT			GPIOE
#define 	EBI_D6_PIN			GPIO_PIN_9
#define 	EBI_D7_PORT			GPIOE
#define 	EBI_D7_PIN			GPIO_PIN_10
#define 	EBI_D8_PORT			GPIOE
#define 	EBI_D8_PIN			GPIO_PIN_11
#define 	EBI_D9_PORT			GPIOE
#define 	EBI_D9_PIN			GPIO_PIN_12
#define 	EBI_D10_PORT			GPIOE
#define 	EBI_D10_PIN			GPIO_PIN_13
#define 	EBI_D11_PORT			GPIOE
#define 	EBI_D11_PIN			GPIO_PIN_14
#define 	EBI_D12_PORT			GPIOE
#define 	EBI_D12_PIN			GPIO_PIN_15
#define 	EBI_D13_PORT			GPIOD
#define 	EBI_D13_PIN			GPIO_PIN_8
#define 	EBI_D14_PORT			GPIOD
#define 	EBI_D14_PIN			GPIO_PIN_9
#define 	EBI_D15_PORT			GPIOD
#define 	EBI_D15_PIN			GPIO_PIN_10


#define 	EBI_NE3_PORT		GPIOC
#define 	EBI_NE3_PIN		GPIO_PIN_11



#define 	EBI_NOE_PORT			GPIOD
#define 	EBI_NOE_PIN			GPIO_PIN_4
#define 	EBI_NWE_PORT			GPIOD
#define 	EBI_NWE_PIN			GPIO_PIN_5

#define 	EBI_NBL0_PORT			GPIOE
#define 	EBI_NBL0_PIN			GPIO_PIN_0
#define 	EBI_NBL1_PORT			GPIOE
#define 	EBI_NBL1_PIN			GPIO_PIN_1

GPIO_TypeDef * EBI_SRAM_ADD_PORT[EBI_SRAM_ADDRESS_PORTn] = { 
				   EBI_A0_PORT, EBI_A1_PORT,
				   EBI_A2_PORT, EBI_A3_PORT,
				   EBI_A4_PORT, EBI_A5_PORT,
				   EBI_A6_PORT, EBI_A7_PORT,
				   EBI_A8_PORT, EBI_A9_PORT,
				   EBI_A10_PORT,EBI_A11_PORT,
				   EBI_A12_PORT,EBI_A13_PORT,
				   EBI_A14_PORT,EBI_A15_PORT,
				   EBI_A16_PORT,EBI_A17_PORT,
				   EBI_A18_PORT };
				   				   
const uint16_t EBI_SRAM_ADD_PIN[EBI_SRAM_ADDRESS_PINn] = {  
				   EBI_A0_PIN, EBI_A1_PIN,
				   EBI_A2_PIN, EBI_A3_PIN,			   
				   EBI_A4_PIN, EBI_A5_PIN,			   
				   EBI_A6_PIN, EBI_A7_PIN,			   
				   EBI_A8_PIN, EBI_A9_PIN,			   
				   EBI_A10_PIN,EBI_A11_PIN,			   
				   EBI_A12_PIN,EBI_A13_PIN,			   
				   EBI_A14_PIN,EBI_A15_PIN,
				   EBI_A16_PIN,EBI_A17_PIN,
				   EBI_A18_PIN };

GPIO_TypeDef * EBI_SRAM_DATA_PORT[EBI_SRAM_DATA_PORTn] = { 
				   EBI_D0_PORT, EBI_D1_PORT,
				   EBI_D2_PORT, EBI_D3_PORT,
				   EBI_D4_PORT, EBI_D5_PORT,
				   EBI_D6_PORT, EBI_D7_PORT,
				   EBI_D8_PORT, EBI_D9_PORT,
				   EBI_D10_PORT,EBI_D11_PORT,
				   EBI_D12_PORT,EBI_D13_PORT,
				   EBI_D14_PORT,EBI_D15_PORT };

const uint16_t EBI_SRAM_DATA_PIN[EBI_SRAM_DATA_PINn] = {  
				   EBI_D0_PIN, EBI_D1_PIN,
				   EBI_D2_PIN, EBI_D3_PIN,			   
				   EBI_D4_PIN, EBI_D5_PIN,			   
				   EBI_D6_PIN, EBI_D7_PIN,			   
				   EBI_D8_PIN, EBI_D9_PIN,			   
				   EBI_D10_PIN,EBI_D11_PIN,			   
				   EBI_D12_PIN,EBI_D13_PIN,			   
				   EBI_D14_PIN,EBI_D15_PIN };



#endif
