/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

uint32_t key_buf[8]  = {0x00010203, 0x04050607, 0x08090a0b, 0x0c0d0e0f,
		    0x10111213, 0x14151617, 0x18191a1b, 0x1c1d1e1f};
uint32_t plain_buf[4] = {0x00112233, 0x44556677, 0x8899aabb, 0xccddeeff};
uint32_t result_buf[4];
uint32_t expert_buf[4] = {0x8ea2b7ca, 0x516745bf, 0xeafc4990, 0x4b496089};
crypt_handle_t h_crypt;
uint8_t count = 0;
uint8_t error = 0;

/**
  * @brief  crypt completed callback.
  * @param  arg: Pointer to crypt_handle_t structure.
  * @retval None.
  */
void crypt_complete(crypt_handle_t *arg)
{
	ald_crypt_clear_flag_status(arg, CRYPT_FLAG_DONE);
	++count;
	return;
}

/**
  * @brief  crypt error callback.
  * @param  arg: Pointer to crypt_handle_t structure.
  * @retval None.
  */
void error_complete(crypt_handle_t *arg)
{
	++error;
	return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);
	/* Enable CRC mode clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	/* Initialize crypt */
	h_crypt.perh           = CRYPT;
	h_crypt.init.mode      = CRYPT_MODE_ECB;
	h_crypt.init.key       = CRYPT_AES_BITS_256;
	h_crypt.init.type      = DATA_32_BIT;
	h_crypt.crypt_cplt_cbk = crypt_complete;
	h_crypt.err_cplt_cbk   = error_complete;
	ald_crypt_init(&h_crypt);

	/* 3DES 2Keys have 4 words key */
	ald_crypt_write_key(&h_crypt,key_buf,KEY_8_LEN);

	/* Start DES encrypt bu dma and the result is :
	 * 8e a2 b7 ca 51 67 45 bf ea fc 49 90 4b 49 60 89 */
	ald_crypt_encrypt_by_dma(&h_crypt, (uint8_t*)plain_buf, (uint8_t*)result_buf, 16, 1, 2);
	ald_delay_ms(3000);
	/* Start DES decrypt by dma */
	ald_crypt_decrypt_by_dma(&h_crypt, (uint8_t*)expert_buf, (uint8_t*)result_buf, 16,3, 4);

	while (1) {
		ald_delay_ms(1000);
	}
}
/**
  * @}
  */
/**
  * @}
  */
