/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include <string.h>
#include "main.h"


/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

crypt_handle_t h_crypt;
uint8_t count = 0;
uint8_t error = 0;

/**
  * @brief  crypt completed callback.
  * @param  arg: Pointer to crypt_handle_t structure.
  * @retval None.
  */
void crypt_complete(crypt_handle_t *arg)
{
	ald_crypt_clear_flag_status(arg, CRYPT_FLAG_DONE);
	++count;
	return;
}

/**
  * @brief  crypt error callback.
  * @param  arg: Pointer to crypt_handle_t structure.
  * @retval None.
  */
void error_complete(crypt_handle_t *arg)
{
	++error;
	return;
}

void test_aes_ctr_128()
{
	uint32_t plain_buffer[16] = {	0x6bc1bee2, 0x2e409f96, 0xe93d7e11, 0x7393172a,
					0xae2d8a57, 0x1e03ac9c, 0x9eb76fac, 0x45af8e51,
					0x30c81c46, 0xa35ce411, 0xe5fbc119, 0x1a0a52ef,
					0xf69f2445, 0xdf4f9b17, 0xad2b417b, 0xe66c3710};
	uint32_t result_buffer[16] = {0};
	uint32_t expect_buffer[16] = {	0x874d6191, 0xb620e326, 0x1bef6864, 0x990db6ce,
					0x9806f66b, 0x7970fdff, 0x8617187b, 0xb9fffdff,
					0x5ae4df3e, 0xdbd5d35e, 0x5b4f0902, 0x0db03eab,
					0x1e031dda, 0x2fbe03d1, 0x792170a0, 0xf3009cee};
	
	uint32_t key_buf[4]   = {0x2b7e1516, 0x28aed2a6, 0xabf71588, 0x09cf4f3c};
	uint32_t ivr_buf[4]   = {0xf0f1f2f3, 0xf4f5f6f7, 0xf8f9fafb, 0xfcfdfeff};

	/* Clear lpuart_handle_t structure */
	memset(&h_crypt, 0x0, sizeof(crypt_handle_t));

	/* Initialize crypt */
	h_crypt.perh           = CRYPT;
	h_crypt.init.mode      = CRYPT_MODE_CTR;//CRYPT_MODE_ECB
	h_crypt.init.key       = CRYPT_AES_BITS_128;
	h_crypt.init.type      = DATA_32_BIT;
	h_crypt.crypt_cplt_cbk = crypt_complete;
	h_crypt.err_cplt_cbk   = error_complete;
	ald_crypt_init(&h_crypt);

	/* Start DES decrypt,right result_buffer equal to expect_buffer */
	ald_crypt_write_key(&h_crypt,key_buf,KEY_4_LEN);
	ald_crypt_write_ivr(&h_crypt,ivr_buf,IV_4_LEN);
 	ald_crypt_encrypt(&h_crypt,(uint8_t*)plain_buffer, (uint8_t*)result_buffer, 64);

	/* Start DES decrypt,right result_buffer equal to plain_buffer */
	ald_crypt_write_key(&h_crypt,key_buf,KEY_4_LEN);
	ald_crypt_write_ivr(&h_crypt,ivr_buf,IV_4_LEN);
 	ald_crypt_encrypt(&h_crypt,(uint8_t*)expect_buffer, (uint8_t*)result_buffer, 64);
	
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	/* Initialize ALD */
	ald_cmu_init();
	/* Configure system clock */
	ald_cmu_pll1_config(CMU_PLL1_INPUT_HRC_6, CMU_PLL1_OUTPUT_48M);
	ald_cmu_clock_config(CMU_CLOCK_PLL1, 48000000);

	/* Enable CRC mode clock */
	ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

	/* Aes ctr mode case */
	test_aes_ctr_128();

	while (1) {
		ald_delay_ms(1000);
	}
}

/**
  * @}
  */
/**
  * @}
  */
