/**
  *********************************************************************************
  *
  * @file    irq.c
  * @brief   Interrupt handler
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"
#include "utils.h"
#include "ald_cmu.h"
#ifdef ALD_DMA
#include "ald_dma.h"
#endif

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */
extern adc_handle_t h_adc;
extern env_t _env;
extern dma_descriptor_t dma0_ctrl_base[28];

uint16_t desbuf1[256];
uint16_t desbuf2[256]; 
uint16_t desbuf3[256]; 
uint16_t desbuf4[256]; 
uint16_t i;

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
	/* Added Emergency operation */
	return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
	/* Added debug information */
	while (1)
		;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
	/* Added debug information */
	while (1)
		;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
	/* Added debug information */
	while (1)
		;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
	/* Added debug information */
	while (1)
		;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
	/* Added system callback */
	return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
	/* Added debug operation */
	return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
	/* Added thread switching operation */
	return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
	ald_inc_tick();
	return;
}

#ifdef ALD_DMA
/**
  * @brief  DMA IRQ#66 handler
  * @retval None
  */
void DMA_Handler(void)
{
	GPIOB->BIR = 0x20;
	
	/* Clear DMA flag */
	DMA0->ICFR = 1;
	/* Close DMA channel1 */
	DMA0->CHENCLR = 1;
	dma0_ctrl_base[0].ctrl.word = 0x5D000031;
	
	/* Get converted value */
	desbuf1[i] = _env.buf[0];
	desbuf2[i] = _env.buf[1];
	desbuf3[i] = _env.buf[2];
	desbuf4[i] = _env.buf[3];
	++i;
	if(i == 256) {
		i = 0;
	}
	
	/* Enable DMA channel1 */
	DMA0->CHENSET = 1;
}
#endif

/**
  * @brief  AD16C4T0 handler
  * @retval None
  */
void AD16C4T0_UP_Handler(void)
{
	AD16C4T0->ICR = 1;
	GPIOB->BIR = (1 << 4);
}
/**
  * @}
  */
/**
  * @}
  */
