/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __MAIN_H__
#define __MAIN_H__

#include "ald_conf.h"


#define USR_ADC_COUNT	100

#define USR_ADC_CH_NR 4

/* IO pin definition */
#define GPIO_CH0_PORT  	GPIOC
#define ADC_CH0_PIN  	GPIO_PIN_0
#define GPIO_CH2_PORT  	GPIOC
#define ADC_CH2_PIN  	GPIO_PIN_2
#define GPIO_CH3_PORT  	GPIOC
#define ADC_CH3_PIN  	GPIO_PIN_3
#define GPIO_CH9_PORT  	GPIOA
#define ADC_CH9_PIN  	GPIO_PIN_5

#define UART_PORT_TX	GPIOB
#define UART_PIN_TX	GPIO_PIN_10
#define UART_FUNC_TX	GPIO_FUNC_3
#define UART_PORT_RX	GPIOB
#define UART_PIN_RX	GPIO_PIN_11
#define UART_FUNC_RX	GPIO_FUNC_3

typedef struct env_s {
	uint8_t flag;
	uint16_t value;
	uint32_t cnt;
	uint16_t buf[USR_ADC_COUNT];
} env_t;

#endif
