/**
  *********************************************************************************
  *
  * @file    main.h
  * @brief   Header file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __MAIN_H__
#define __MAIN_H__

#include "ald_conf.h"

/* IO pin definition */
#define GPIO_CH0_PORT  	GPIOC
#define ADC_CH0_PIN  	GPIO_PIN_0
#define GPIO_CH2_PORT  	GPIOC
#define ADC_CH2_PIN  	GPIO_PIN_2

#define UART_PORT_TX	GPIOB
#define UART_PIN_TX	GPIO_PIN_10
#define UART_FUNC_TX	GPIO_FUNC_3
#define UART_PORT_RX	GPIOB
#define UART_PIN_RX	GPIO_PIN_11
#define UART_FUNC_RX	GPIO_FUNC_3

extern adc_handle_t h_adc;

typedef void (*cmd_fn1)(uint32_t arg);
typedef void (*cplt_cbk)(int32_t value);

typedef struct env_s {
	uint32_t flag;
	
	uint32_t n_cnt;
	uint32_t n_sum;
	uint32_t n_min;
	uint32_t n_max;
	uint32_t n_vol;
	cplt_cbk n_cbk;

	uint32_t i_cnt;
	uint32_t i_sum;
	uint32_t i_min;
	uint32_t i_max;
	uint32_t i_vol;
	cplt_cbk i_cbk;
} env_t;

#endif
