/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */ 
#define LVGL_THREAD_PRIORITY   4
#define LVGL_THREAD_STACK_SIZE 2048
#define LVGL_THREAD_TIMESLICE  10

#define KEY_THREAD_PRIORITY   24
#define KEY_THREAD_STACK_SIZE 512
#define KEY_THREAD_TIMESLICE  10

#define START_THREAD_PRIORITY   25
#define START_THREAD_STACK_SIZE 1024
#define START_THREAD_TIMESLICE  10

/* Thread handlers */
static rt_thread_t lvgl_thread = RT_NULL;
static rt_thread_t start_thread = RT_NULL;
static rt_thread_t key_thread = RT_NULL;

/* Thread functions */
static void app_lvgl_thread_entry(void* parameter);
static void app_start_thread_entry(void* parameter);
static void app_key_thread_entry(void *parameter);

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	start_thread = rt_thread_create("start_thread",
                                          app_start_thread_entry, 
	                                  RT_NULL,
                                          START_THREAD_STACK_SIZE,
                                          START_THREAD_PRIORITY, 
	                                  START_THREAD_TIMESLICE);
	if (start_thread != RT_NULL)
		rt_thread_startup(start_thread);
	
	return RT_EOK;
}


/**
  * @brief  LVGL thread entry function
  * @param  parameter: user's paramter
  * @retval None
  */
static void app_lvgl_thread_entry(void* parameter)
{
	lv_init();
	lv_port_disp_init();
	lv_port_indev_init();
	app_lvgl_main_gui(lv_scr_act());

	while(1) {
		rt_thread_mdelay(5);
		lv_task_handler();
	}
}

/**
  * @brief  KEY thread entry function
  * @param  parameter: user's paramter
  * @retval None
  */
static void app_key_thread_entry(void* parameter)
{
	while(1) {
		rt_thread_mdelay(500);
		bsp_led_toggle(3);
	}
}

/**
  * @brief  System thread create function
  * @retval None
  */
static void app_thread_create (void)
{
	key_thread = rt_thread_create("key_thread",
                                          app_key_thread_entry, 
	                                  RT_NULL,
                                          KEY_THREAD_STACK_SIZE,
                                          KEY_THREAD_PRIORITY, 
	                                  KEY_THREAD_TIMESLICE);
	if (key_thread != RT_NULL)
		rt_thread_startup(key_thread);
	
	lvgl_thread = rt_thread_create("lvgl_thread",
                                          app_lvgl_thread_entry, 
	                                  RT_NULL,
                                          LVGL_THREAD_STACK_SIZE,
                                          LVGL_THREAD_PRIORITY, 
	                                  LVGL_THREAD_TIMESLICE);
	if (lvgl_thread != RT_NULL)
		rt_thread_startup(lvgl_thread);
}

/**
  * @brief  System object create function
  * @retval None
  */
static void app_obj_create(void)
{
	/* Create Samepher \ Event */
}

/**
  * @brief  System start entry function
  * @param  parameter: Pointer to user's parameter
  * @retval None
  */
static void app_start_thread_entry(void* parameter)
{
	/* Create semaphore\mutex\event and so on */
	app_obj_create();
	/* Create threads */
	app_thread_create();
	bsp_led_init();
	bsp_key_init();
	while (1) {
		bsp_key_scan();
		rt_thread_mdelay(10);
	}
}

/**
  * @}
  */
/**
  * @}
  */
