/**
  *********************************************************************************
  *
  * @file    select_win.c
  * @brief   select winow
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */
#include <stdio.h>
#include "select_win.h"
#include "color_win.h"
#include "chart_win.h"

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @defgroup SELECT_WIN main_win 
  * @{
  */

LV_IMG_DECLARE(progress_img);
LV_IMG_DECLARE(chart_img);

#define SPLIT_LINE_WIDTH		200 
static lv_obj_t * select_win;
static lv_obj_t * color_item_btn, * select_item_btn;
static lv_obj_t * btnm;
const char * const BTNM_MAP[] = {
	"    "LV_SYMBOL_AUDIO"\nAUDIO","  "LV_SYMBOL_BELL"\nBELL","\n",
	"   "LV_SYMBOL_CALL"\nCALL","  "LV_SYMBOL_GPS"\nGPS",
	""
};
const lv_point_t SPLIT_LINE_POINTS[2] = {{0,0},{SPLIT_LINE_WIDTH,0}};

/** @defgroup SELECT_WIN_Public_Functions select_win Public Functions
  * @{
  */

/**
  * @brief  btn event handler
  * @param  num: pointer to an object
  * @param  event: btn event
  * @retval None
  */
static void event_handler(lv_obj_t * obj, lv_event_t event)
{
	if(obj == color_item_btn) {
		if(event == LV_EVENT_CLICKED)
			progress_win_create(lv_scr_act());
	} else if(obj == select_item_btn) {
		if(event == LV_EVENT_CLICKED)
			chart_win_create(lv_scr_act());
	} 
	
}

/**
  * @brief  select tab init
  * @param  parent: pointer to an object
  * @retval None
  */
void select_tab_init(lv_obj_t * parent)
{
	static lv_style_t title_style;
	
	lv_obj_t * title_label = lv_label_create(parent, NULL);
	lv_style_copy(&title_style, lv_obj_get_style(title_label));
	title_style.text.font = &lv_font_roboto_22;
	lv_label_set_style(title_label, LV_LABEL_STYLE_MAIN, &title_style);
	lv_label_set_text(title_label, "Eastsoft");
	lv_obj_align(title_label, NULL, LV_ALIGN_IN_TOP_MID, 0, 10);
	
	lv_obj_t * list = lv_list_create(parent, NULL);
	lv_obj_set_size(list, lv_obj_get_width(parent)*0.9f, lv_obj_get_height(parent) - 60);
	lv_obj_align(list, title_label, LV_ALIGN_OUT_BOTTOM_MID, 0, 10);
	lv_list_set_sb_mode(list, LV_SB_MODE_AUTO);
	
	color_item_btn = lv_list_add_btn(list, &progress_img, "Progress");
	lv_obj_set_event_cb(color_item_btn, event_handler);
	
	select_item_btn = lv_list_add_btn(list, &chart_img, "Chart");
	lv_obj_set_event_cb(select_item_btn, event_handler);
}

/**
  * @brief  list tab init
  * @param  parent: pointer to an object
  * @retval None
  */
void list_tab_init(lv_obj_t * parent)
{
	uint16_t parent_width = lv_obj_get_width(parent);

	lv_obj_t * split_line = lv_line_create(parent, NULL);
	lv_obj_set_size(split_line, SPLIT_LINE_WIDTH, 2);
	lv_line_set_points(split_line, SPLIT_LINE_POINTS, 2);
	lv_obj_align(split_line, NULL, LV_ALIGN_IN_TOP_MID, 0, 100);
	
	btnm = lv_btnm_create(parent, NULL);
	lv_obj_set_size(btnm,parent_width*0.8f, 100);
	lv_obj_align(btnm, split_line, LV_ALIGN_OUT_BOTTOM_MID, 0, 10);
	lv_btnm_set_map(btnm, (const char**)BTNM_MAP);
	lv_obj_set_event_cb(btnm, event_handler);
}

/**
  * @brief  select gui init
  * @param  parent: pointer to parent object
  * @retval None
  */
void app_lvgl_select_gui(lv_obj_t * parent)
{
	select_win = lv_tabview_create(parent, NULL);
	lv_tabview_set_btns_pos(select_win, LV_TABVIEW_BTNS_POS_BOTTOM);
	lv_obj_t * home_tab = lv_tabview_add_tab(select_win, LV_SYMBOL_HOME" Home");
	select_tab_init(home_tab);
	lv_obj_t * setting_tab = lv_tabview_add_tab(select_win, LV_SYMBOL_LIST" LIST");
	list_tab_init(setting_tab);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
