/**
  *********************************************************************************
  *
  * @file    main_win.c
  * @brief   main winow
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */
#include <stdio.h>
#include "main_win.h"
#include "select_win.h"

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @defgroup MAIN_WIN main_win 
  * @{
  */

/** @defgroup MAIN_WIN_Public_Functions main_win Public Functions
  * @{
  */

LV_IMG_DECLARE(title)
static lv_obj_t * main_win;

/**
  * @brief  btn1 event handler
  * @param  obj: pointer to obj
  * @param  event: bten event
  * @retval None
  */
static  void btn1_event_handler(struct _lv_obj_t * obj, lv_event_t event)
{
	if (event == LV_EVENT_RELEASED) {
		lv_obj_del(main_win);
		main_win = NULL;
		app_lvgl_select_gui(lv_scr_act());
	}
}

/**
  * @brief  App default gui
  * @retval None
  */
void app_lvgl_main_gui(lv_obj_t * parent)
{
	uint16_t pwidth, pheight;
	
	lv_theme_t * theme = lv_theme_night_init(210,NULL);
	lv_theme_set_current(theme);
	
	pwidth  = lv_obj_get_width(parent);
	pheight = lv_obj_get_height(parent);
	main_win = lv_cont_create(parent,NULL);
	lv_obj_set_size(main_win, pwidth, pheight);
	lv_cont_set_layout(main_win, LV_LAYOUT_OFF);
	
	lv_obj_t * head_label = lv_label_create(main_win, NULL);
	lv_label_set_recolor(head_label, true);
	lv_label_set_text(head_label,"#808000 ES32F3696LX  ##808000 Discovery  ##808000 Board#  V1.0");
	lv_obj_align(head_label, NULL, LV_ALIGN_IN_TOP_MID, 0, 10);
	
	lv_obj_t * img_var = lv_img_create(main_win, NULL);
	lv_img_set_src(img_var, &title);
	lv_obj_align(img_var, head_label, LV_ALIGN_OUT_BOTTOM_MID, 0, 10);
	
	lv_obj_t * btn1 = lv_btn_create(main_win, NULL);
	lv_btn_set_style(btn1, LV_BTN_STYLE_REL, &lv_style_transp);
	lv_obj_set_pos(btn1, 260, 440);
	lv_obj_set_size(btn1, 60, 40);
        lv_obj_set_event_cb(btn1, btn1_event_handler);

	static lv_style_t labe0_style;
	lv_style_copy(&labe0_style, &lv_style_scr);
	labe0_style.text.color = lv_color_make(0x55, 0x96, 0xd8);
	lv_obj_t * labe0 = lv_label_create(btn1, NULL);
	lv_label_set_style(labe0, LV_LABEL_STYLE_MAIN, &labe0_style);
	lv_label_set_text(labe0, LV_SYMBOL_RIGHT);
	
	/* Show mcu basic information */
	lv_obj_t *label1 = lv_label_create(main_win, NULL);
	static lv_style_t label;
	lv_style_copy(&label, &lv_style_scr);
	label.text.font = &lv_font_roboto_16;
	label.text.color = LV_COLOR_OLIVE;
	lv_label_set_style(label1, LV_LABEL_STYLE_MAIN, &label);
	lv_label_set_text(label1, "Mcu:    ES32F3696LX\r\n"
                                  "Core:   ARM Cortex-M3\r\n"
                                  "Freq:   96Mhz\r\n"
			          "Ram:    96Kb\r\n"
			          "Flash:  512Kb\r\n");
	lv_obj_align(label1, img_var, LV_ALIGN_OUT_BOTTOM_LEFT, 20, 15);
}






/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
