/**
  *********************************************************************************
  *
  * @file    color_win.c
  * @brief   color winow
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */
#include <stdio.h>
#include "color_win.h"
#include "app_gui.h"

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @defgroup COLOR_WIN color_win 
  * @{
  */

/** @defgroup COLOR_WIN_Public_Functions adc_win Public Functions
  * @{
  */

static lv_obj_t * arc1;
static lv_obj_t * progress_label;
static lv_obj_t * bar1;
static lv_task_t * task = NULL;
uint8_t progress_val;

/**
  * @brief  progress btn event handler
  * @param  obj: pointer to an object
  * @param  event: btn event
  * @retval None
  */
static void event_handler(lv_obj_t * obj, lv_event_t event)
{
	if(event == USER_EVENT_BACK) {
		if(task) {
			lv_task_del(task);
			task = NULL;
		}
	}
}

/**
  * @brief  progress value set
  * @param  val: set value
  * @retval None
  */
static void progress_set_val(uint8_t val)
{
	char buff[10];
	
	lv_arc_set_angles(arc1, 0, (uint16_t)(3.6f*val));
	lv_bar_set_value(bar1, val, LV_ANIM_OFF);
	sprintf(buff,"%d%%", val);
	lv_label_set_text(progress_label, buff);
	lv_obj_realign(progress_label);
}

/**
  * @brief  progress task
  * @param  t: pointer to task 
  * @retval None
  */
static void progress_task(lv_task_t * t)
{
	progress_val++;
	if(progress_val > 100)
		 progress_val = 0;
	progress_set_val(progress_val);
}

/**
  * @brief  progress win create
  * @param  parent: pointer to an object
  * @retval None
  */
void progress_win_create(lv_obj_t * parent)
{
	lv_obj_t * win = app_general_win_create(parent, "Progress");
	lv_obj_set_event_cb(win, event_handler);
	
	lv_obj_t * preload1 = lv_preload_create(win, NULL);
	lv_obj_set_size(preload1, 100, 100);
	lv_obj_align(preload1, NULL, LV_ALIGN_IN_TOP_MID, 0, 40);
	lv_preload_set_arc_length(preload1, 45);
	lv_preload_set_dir(preload1, LV_PRELOAD_DIR_BACKWARD);
	lv_preload_set_type(preload1, LV_PRELOAD_TYPE_FILLSPIN_ARC);
	lv_preload_set_spin_time(preload1, 2000);
	
	arc1 = lv_arc_create(win, NULL);
	lv_arc_set_angles(arc1, 180, 90);
	lv_obj_set_size(arc1, 100, 100);
	lv_obj_align(arc1,preload1,LV_ALIGN_OUT_BOTTOM_MID, 0, 15);
	progress_label = lv_label_create(win, NULL);
	lv_obj_align(progress_label, arc1,LV_ALIGN_CENTER, 0, 0);
	
	bar1 = lv_bar_create(win, NULL);
	lv_obj_set_size(bar1, 180, 10);
	lv_obj_align(bar1,arc1, LV_ALIGN_OUT_BOTTOM_MID, 0, 15);
	
	progress_val = 0;
	progress_set_val(progress_val);
	if(task == NULL)
		task = lv_task_create(progress_task, 400, LV_TASK_PRIO_MID,NULL);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
