/**
  *********************************************************************************
  *
  * @file    chart_win.c
  * @brief   chart winow
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */
#include <stdio.h>
#include "chart_win.h"
#include "app_gui.h"

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @defgroup CHART_WIN chart_win 
  * @{
  */

/** @defgroup CHART_WIN_Public_Functions chart_win Public Functions
  * @{
  */

#define POINT_COUNT   	10  
#define SLIDER_MAX_VAL	100	
static lv_coord_t series1_y[POINT_COUNT] = {30,60,40,60,20,60,50,80,60,80};
static lv_obj_t * chart1;
static lv_chart_series_t * series1;
static lv_obj_t * slider1;
static lv_obj_t *  sw1;
static lv_obj_t * cb1;

/**
  * @brief  chart win event handler
  * @param  parent: pointer to an object
  * @param  event: pointer to an object
  * @retval None
  */
static void event_handler(lv_obj_t * obj, lv_event_t event)
{
	float val;
	uint8_t i;
	bool sta;
	
	if(event==LV_EVENT_VALUE_CHANGED) {
		if(obj == slider1) {
			val = lv_slider_get_value(obj);
			val /= SLIDER_MAX_VAL;
			for(i = 0; i < POINT_COUNT; i++)
				series1->points[i] = (lv_coord_t)(val * series1_y[i]);
			lv_chart_refresh(chart1);
		} else if(obj == sw1) {
			sta = lv_sw_get_state(obj);
			if(sta)
				lv_chart_set_type(chart1, LV_CHART_TYPE_POINT | LV_CHART_TYPE_LINE);
			else
				lv_chart_set_type(chart1,LV_CHART_TYPE_COLUMN);
		} else if(obj == cb1) {
			sta = lv_cb_is_checked(obj);
			if(sta)
				lv_chart_set_type(chart1,LV_CHART_TYPE_AREA);
			else
				lv_chart_set_type(chart1,LV_CHART_TYPE_POINT|LV_CHART_TYPE_LINE);
		}
	}
}

/**
  * @brief  chart win create
  * @param  parent: pointer to an object
  * @retval None
  */
void chart_win_create(lv_obj_t * parent)
{
	lv_obj_t * win;
	
	win = app_general_win_create(parent, "Chart");
	chart1 = lv_chart_create(win, NULL);
	lv_obj_set_size(chart1, 180, 200);
	lv_obj_align(chart1, NULL, LV_ALIGN_IN_TOP_MID, 17, 40);
	lv_chart_set_type(chart1, LV_CHART_TYPE_POINT | LV_CHART_TYPE_LINE);
	lv_chart_set_series_opa(chart1, LV_OPA_80);
	lv_chart_set_series_width(chart1, 4);
	lv_chart_set_series_darking(chart1, LV_OPA_80);
	lv_chart_set_point_count(chart1, POINT_COUNT);
	lv_chart_set_div_line_count(chart1, 4, 4);
	lv_chart_set_range(chart1, 0, 100);
	lv_chart_set_y_tick_length(chart1, 10, 3);
	lv_chart_set_y_tick_texts(chart1, "100\n80\n60\n40\n20\n0", 2, LV_CHART_AXIS_DRAW_LAST_TICK);
	lv_chart_set_x_tick_length(chart1,10,3);
	lv_chart_set_x_tick_texts(chart1, "0\n2\n4\n6\n8\n10", 2, LV_CHART_AXIS_DRAW_LAST_TICK);
	lv_chart_set_margin(chart1, 40);
	
	series1 = lv_chart_add_series(chart1, LV_COLOR_RED);
	lv_chart_set_points(chart1, series1, (lv_coord_t*)series1_y);
	
	slider1 = lv_slider_create(win, NULL);
	lv_obj_set_size(slider1, 200, 20);
	lv_slider_set_range(slider1, 0, SLIDER_MAX_VAL);
	lv_slider_set_value(slider1, SLIDER_MAX_VAL,LV_ANIM_OFF);
	lv_obj_align(slider1,chart1, LV_ALIGN_OUT_BOTTOM_MID, -17, 45);
	lv_obj_set_event_cb(slider1, event_handler);
	
	cb1 = lv_cb_create(win, NULL);
	lv_cb_set_text(cb1, "Area type");
	lv_cb_set_checked(cb1, false);
	lv_obj_align(cb1,slider1, LV_ALIGN_OUT_BOTTOM_MID, 0, 15);
	lv_obj_set_event_cb(cb1, event_handler);
	
	sw1 = lv_sw_create(win, NULL);
	lv_obj_set_size(sw1, 80, 40);
	lv_obj_align(sw1,cb1, LV_ALIGN_OUT_BOTTOM_MID, 0, 15);
	lv_sw_on(sw1, LV_ANIM_ON);
	lv_obj_set_event_cb(sw1, event_handler);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
