/**
  *********************************************************************************
  *
  * @file    app_gui.c
  * @brief   app gui
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#include "app_gui.h"

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @defgroup APP_GUI app_gui 
  * @{
  */

#define	TOP_OFFSET	5
#define BACK_BTN_TITLE		LV_SYMBOL_LEFT" Back\n"  

/** @defgroup APP_GUI_Public_Functions chart_win Public Functions
  * @{
  */
static void back_btn_event_handler(lv_obj_t * obj,lv_event_t event)
{
	if(event == LV_EVENT_PRESSED) {
		lv_label_set_text(obj,"#444444 "BACK_BTN_TITLE"#");	
		lv_label_set_recolor(obj,true);
	} else if(event == LV_EVENT_RELEASED||event==LV_EVENT_PRESS_LOST) {
		obj = lv_obj_get_parent(obj);
		obj = lv_obj_get_parent(obj);				
		lv_event_cb_t event_cb = lv_obj_get_event_cb(obj);
		if(event_cb)						
			event_cb(obj, USER_EVENT_BACK);
		lv_obj_del(obj);					
	}
}

/**
  * @brief  app general win create
  * @param  parent: pointer to an object
  * @param  title: pointer to title name
  * @retval None
  */
lv_obj_t * app_general_win_create(lv_obj_t * parent, const char * title)
{
	lv_obj_t * win;
	
	win = lv_page_create(parent,NULL);					//lv_pageҳģⴰ
	lv_obj_set_size(win,lv_obj_get_width(parent),lv_obj_get_height(parent));//ôĴС
	lv_page_set_sb_mode(win,LV_SB_MODE_AUTO);				//ùģʽΪԶ
	lv_page_set_edge_flash(win,true);					//ʹܱԵԲЧ
	lv_page_set_style(win,LV_PAGE_STYLE_SCRL,&lv_style_transp_tight);	//scrlʽΪ͸

	lv_obj_t * title_label = lv_label_create(win,NULL);
	lv_label_set_text(title_label, title);					//ô
	lv_obj_align(title_label, NULL,LV_ALIGN_IN_TOP_MID, 0, TOP_OFFSET);	//ö뷽ʽ

	lv_obj_t * back_btn = lv_label_create(win, NULL);			//ñǩģⰴť
	lv_label_set_text(back_btn, BACK_BTN_TITLE);				//ı
	lv_obj_align(back_btn, NULL, LV_ALIGN_IN_TOP_LEFT, 5, TOP_OFFSET);		//ö뷽ʽ
	lv_obj_set_click(back_btn, true);					//ʹܵ
	lv_obj_set_event_cb(back_btn, back_btn_event_handler);			//¼ص,ڹرմ
	
	return win;
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
