/**
  *********************************************************************************
  *
  * @file    main.c
  * @brief   Main file for DEMO
  *
  * @version V1.0
  * @date    26 Jun 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          26 Jun 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#include "main.h"

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */ 
#define LVGL_THREAD_PRIORITY   4
#define LVGL_THREAD_STACK_SIZE 2048
#define LVGL_THREAD_TIMESLICE  10

#define KEY_THREAD_PRIORITY   24
#define KEY_THREAD_STACK_SIZE 512
#define KEY_THREAD_TIMESLICE  10

#define START_THREAD_PRIORITY   25
#define START_THREAD_STACK_SIZE 1024
#define START_THREAD_TIMESLICE  10

/* Thread handlers */
static rt_thread_t lvgl_thread = RT_NULL;
static rt_thread_t start_thread = RT_NULL;
static rt_thread_t key_thread = RT_NULL;

/* Thread functions */
static void app_lvgl_thread_entry(void* parameter);
static void app_start_thread_entry(void* parameter);
static void app_key_thread_entry(void *parameter);

LV_IMG_DECLARE(title)

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
	start_thread = rt_thread_create("start_thread",
                                          app_start_thread_entry, 
	                                  RT_NULL,
                                          START_THREAD_STACK_SIZE,
                                          START_THREAD_PRIORITY, 
	                                  START_THREAD_TIMESLICE);
	if (start_thread != RT_NULL)
		rt_thread_startup(start_thread);
	
	return RT_EOK;
}

/**
  * @brief  App default gui
  * @retval None
  */
void app_lvgl_gui(void)
{
	/* Create a default object and set LV_STYLE_PRETTY_COLOR style */
	lv_obj_t * obj1 = lv_obj_create(lv_disp_get_scr_act(NULL), NULL);
	lv_obj_set_style(obj1, &lv_style_plain_color);
	lv_obj_set_size(obj1, 320, 40);

	static lv_style_t header_style;
	lv_style_copy(&header_style, &lv_style_scr);
	header_style.text.font = &lv_font_roboto_16;
	header_style.text.color = LV_COLOR_RED;
    
	lv_obj_t * Hlabel = lv_label_create(lv_disp_get_scr_act(NULL), NULL);
	lv_label_set_style(Hlabel, LV_LABEL_STYLE_MAIN, &header_style);
	lv_label_set_text(Hlabel, "ES32F3696LX Discovery Board V1.0");
	lv_obj_set_pos(Hlabel, 10, 10);
	
	lv_obj_t * btn1 = lv_btn_create(lv_disp_get_scr_act(NULL), NULL);
	lv_btn_set_style(btn1, LV_BTN_STYLE_REL, &lv_style_scr);
	lv_obj_set_pos(btn1, 280, 320);
	lv_obj_set_size(btn1, 60, 40);
        lv_obj_set_event_cb(btn1, NULL);
#if 0
	static lv_style_t labe0_style;
	lv_style_copy(&labe0_style, &lv_style_scr);
	labe0_style.text.color = lv_color_make(0x55, 0x96, 0xd8);
	lv_obj_t * labe0 = lv_label_create(btn1, NULL);
	lv_label_set_style(labe0, LV_LABEL_STYLE_MAIN, &labe0_style);
	lv_label_set_text(labe0, LV_SYMBOL_RIGHT " Next");
#endif
	/* Show logo under the header */	
	lv_obj_t * img_var = lv_img_create(lv_disp_get_scr_act(NULL), NULL); /*Create an image object*/
	lv_img_set_src(img_var, &title);  	/*Set the created file as image */
	lv_obj_set_pos(img_var,0, 40);          /*Set the positions*/
	lv_obj_set_drag(img_var, true);
	
	/* Show mcu basic information */
	lv_obj_t *label1 = lv_label_create(lv_disp_get_scr_act(NULL), NULL);
	static lv_style_t label;
	lv_style_copy(&label, &lv_style_scr);
	label.text.font = &lv_font_roboto_16;
	lv_label_set_style(label1, LV_LABEL_STYLE_MAIN, &label);
	lv_label_set_text(label1, "Mcu:    ES32F3696LX  \n"
                                  "Core:   ARM Cortex-M3\n"
                                  "Freq:   96Mhz       \n"
			          "Ram:    96KBytes\n"
			          "Flash:  512KBytes    \n");
	lv_obj_align(label1, img_var, LV_ALIGN_OUT_BOTTOM_LEFT, 10, 10);
}

/**
  * @brief  LVGL thread entry function
  * @param  parameter: user's paramter
  * @retval None
  */
static void app_lvgl_thread_entry(void* parameter)
{
	lv_init();
	lv_port_disp_init();
	lv_port_indev_init();
	app_lvgl_gui();

	while(1) {
		rt_thread_mdelay(5);
		lv_task_handler();
	}
}

/**
  * @brief  KEY thread entry function
  * @param  parameter: user's paramter
  * @retval None
  */
static void app_key_thread_entry(void* parameter)
{
	while(1) {
		rt_thread_mdelay(500);
		bsp_led_toggle(3);
	}
}

/**
  * @brief  System thread create function
  * @retval None
  */
static void app_thread_create (void)
{
	key_thread = rt_thread_create("key_thread",
                                          app_key_thread_entry, 
	                                  RT_NULL,
                                          KEY_THREAD_STACK_SIZE,
                                          KEY_THREAD_PRIORITY, 
	                                  KEY_THREAD_TIMESLICE);
	if (key_thread != RT_NULL)
		rt_thread_startup(key_thread);
	
	lvgl_thread = rt_thread_create("lvgl_thread",
                                          app_lvgl_thread_entry, 
	                                  RT_NULL,
                                          LVGL_THREAD_STACK_SIZE,
                                          LVGL_THREAD_PRIORITY, 
	                                  LVGL_THREAD_TIMESLICE);
	if (lvgl_thread != RT_NULL)
		rt_thread_startup(lvgl_thread);
}

/**
  * @brief  System object create function
  * @retval None
  */
static void app_obj_create(void)
{
	/* Create Samepher \ Event */
}

/**
  * @brief  System start entry function
  * @param  parameter: Pointer to user's parameter
  * @retval None
  */
static void app_start_thread_entry(void* parameter)
{
	/* Create semaphore\mutex\event and so on */
	app_obj_create();
	/* Create threads */
	app_thread_create();
	bsp_led_init();
	bsp_key_init();
	while (1) {
		bsp_key_scan();
		rt_thread_mdelay(10);
	}
}

/**
  * @}
  */
/**
  * @}
  */
